vec3 GetSkyColor(vec3 viewPos, vec3 lightCol){
vec3 sky = skyCol;
vec3 nViewPos = normalize(viewPos);

float NdotU = clamp(dot(nViewPos, upVec), 0.0, 1.0);
float NdotS = clamp(dot(nViewPos, sunVec) * 0.5 + 0.5, 0.0, 1.0);

float n = 3.0 * ((1.0 - NdotS) * sunVisibility * (1.0 - rainStrength) *
          (1.0 - 0.5 * timeBrightness)) + HORIZON_DISTANCE;
float horizon = pow(1.0 - abs(NdotU), n) * (0.5 * sunVisibility + 0.3) * (1 - rainStrength * 0.75);
float lightmix = (NdotS * NdotS * (1.0 - NdotU) * pow(1.0 - timeBrightness, 3.0) +
                  horizon * 0.075 * timeBrightness) * sunVisibility * (1.0 - rainStrength);

#ifdef SKY_VANILLA
sky = mix(fogCol, sky, NdotU);
#endif

float ground = 1.0 - exp(-0.0625 * (5.0 * rainStrength + 1.0) * (-5.0 * sunVisibility + 6.0) /
               clamp(dot(nViewPos, -upVec), 0.0, 1.0));
float mult = (0.1 * (1.0 + rainStrength) + horizon) * ground;

sky = mix(sky * pow(max(1.0 - lightmix, 0.0), 1.0 + sunVisibility), lightCol * sqrt(lightCol),
      lightmix) * sunVisibility + (lightNight * lightNight * 0.4);
sky = mix(sky,
          weatherCol * weatherCol * GetLuminance(ambientCol / (weatherCol * weatherCol)) * 1.4,
          rainStrength) * mult;

return pow(sky, vec3(1.125));
}