float CloudNoise(vec2 coord, vec2 wind){
	float noise = texture2D(noisetex, coord*0.5      + wind * 0.55).x;
		  noise+= texture2D(noisetex, coord*0.25     + wind * 0.45).x * 2.0;
		  noise+= texture2D(noisetex, coord*0.125    + wind * 0.35).x * 3.0;
		  noise+= texture2D(noisetex, coord*0.0625   + wind * 0.25).x * 4.0;
		  noise+= texture2D(noisetex, coord*0.03125  + wind * 0.15).x * 5.0;
		  noise+= texture2D(noisetex, coord*0.016125 + wind * 0.05).x * 6.0;
	return noise;
}

float CloudCoverage(float noise, float cosT, float coverage){
	float noiseMix = mix(noise, 21.0, 0.33 * rainStrength);
	float noiseFade = clamp(sqrt(cosT * 10.0), 0.0, 1.0);
	float noiseCoverage = ((coverage * coverage) + CLOUD_AMOUNT);
	float multiplier = 1.0 - 0.5 * rainStrength;

	return max(noiseMix * noiseFade - noiseCoverage, 0.0) * multiplier;
}

vec4 DrawCloud(vec3 viewPos, float dither, vec3 lightCol, vec3 ambientCol) {
	float cosT = dot(normalize(viewPos), upVec);
	float cosS = dot(normalize(viewPos), sunVec);
	const float pi = 3.1415927;

	#if AA == 2
	dither = fract(16.0 * frameTimeCounter + dither);
	#endif
	
	float cloud = 0.0;
	float cloudGradient = 0.0;
	float gradientMix = dither / CLOUD_QUALITY;
	float colorMultiplier = CLOUD_BRIGHTNESS * (0.5 - 0.25 * (1.0 - sunVisibility) * (1.0 - rainStrength));
	float noiseMultiplier = CLOUD_THICKNESS * sqrt(sqrt(8.0 / CLOUD_QUALITY)) * 0.25;
	float scattering = pow(cosS * 0.5 * (2.0 * sunVisibility - 1.0) + 0.5, 6.0);

	vec2 wind = vec2(frametime * CLOUD_SPEED * 0.001,
				     sin(frametime * CLOUD_SPEED * 0.05) * 0.002) * CLOUD_HEIGHT / 15.0;

	vec3 cloudcolor = vec3(0.0);

	if(cosT > 0.1){
		vec3 wpos = normalize((gbufferModelViewInverse * vec4(viewPos, 1.0)).xyz);
		for(int i = 0; i < CLOUD_QUALITY; i++) {
			if(cloud > 0.99) break;
			vec3 planeCoord = wpos * ((CLOUD_HEIGHT + (i + dither) * 4.0 / CLOUD_QUALITY) / wpos.y) * 0.004;
			vec2 coord = cameraPosition.xz * 0.00025 + planeCoord.xz;
			float coverage = float(i - 0.5 * CLOUD_QUALITY + dither) * 4.0 / CLOUD_QUALITY;

			float noise = CloudNoise(coord, wind);
				  noise = CloudCoverage(noise, cosT, coverage) * noiseMultiplier;
				  noise = noise / pow(pow(noise, 2.5) + 1.0, 0.4);

			cloudGradient = mix(cloudGradient,
			                    mix(gradientMix * gradientMix, 1.0 -noise, 0.25),
								noise * (1.0 - cloud * cloud));
			cloud = mix(cloud, 1.0, noise);
			gradientMix += 1.0 / CLOUD_QUALITY;
		}
		cloudcolor = mix(ambientCol * (0.5 * sunVisibility + 0.5),
		                 lightCol * (1.0 + scattering),
						 cloudGradient * cloud);
		cloudcolor *= 1.0 - 0.6 * rainStrength;
		cloud *= sqrt(sqrt(clamp(cosT * 10.0 - 1.0, 0.0, 1.0))) * (1.0 - 0.6 * rainStrength);
	}

	return vec4(cloudcolor * colorMultiplier, cloud * cloud * CLOUD_OPACITY);
}

float GetNoise(vec2 pos){
	return fract(sin(dot(pos, vec2(12.9898, 4.1414))) * 43758.5453);
}

void DrawStars(inout vec3 color, vec3 viewPos){
	vec3 wpos = vec3(gbufferModelViewInverse * vec4(viewPos, 1.0));
	vec3 planeCoord = wpos / (wpos.y + length(wpos.xz));
	vec2 wind = vec2(frametime, 0.0);
	vec2 coord = planeCoord.xz * 0.4 + cameraPosition.xz * 0.0001 + wind * 0.00125;
	coord = floor(coord*1024.0)/1024.0;
	
	float NdotU = max(dot(normalize(viewPos), normalize(upVec)), 0.0);
	float multiplier = sqrt(sqrt(NdotU)) * 5.0 * (1.0 - rainStrength) * moonVisibility;
	
	float star = 1.0;
	if(NdotU > 0.0){
		star *= GetNoise(coord.xy);
		star *= GetNoise(coord.xy+0.1);
		star *= GetNoise(coord.xy+0.23);
	}
	star = max(star - 0.825, 0.0) * multiplier;
		
	color += star * pow(lightNight, vec3(0.8));
}