void GetMaterials(out float smoothness, out float metalness, out float f0, out float metalData, 
                  out float emissive, out float ao, out vec3 normalMap,
                  vec2 newCoord, vec2 dcdx, vec2 dcdy){
    vec4 specularMap = texture2DGradARB(specular, newCoord, dcdx, dcdy);

    #if MATERIAL_FORMAT == 0
    smoothness = specularMap.r;

    f0 = specularMap.g;
    f0 *= f0 < 0.9 ? f0 : 1.0;
    metalness = f0 >= 0.9 ? 1.0 : 0.0;
    metalData = f0;

    emissive = specularMap.a < 1.0 ? specularMap.a : 0.0;
    ao = texture2DGradARB(normals, newCoord, dcdx, dcdy).z;

	normalMap = vec3(texture2DGradARB(normals, newCoord, dcdx, dcdy).xy, 0.0) * 2.0 - 1.0;
    normalMap.z = sqrt(1.0 - dot(normalMap.xy, normalMap.xy));
    #endif

    #if MATERIAL_FORMAT == 1
    smoothness = specularMap.r;
    
    metalness = specularMap.g;
    f0 = 0.78 * metalness + 0.02;
    metalData = metalness;

    emissive = specularMap.b;
    ao = 1.0;

	normalMap = texture2DGradARB(normals, newCoord, dcdx, dcdy).xyz * 2.0 - 1.0;
    normalMap.z = 1.0;
    #endif
}