vec2 blackOutlineOffsets[24] = vec2[24](
	vec2(-2.0,  2.0),
	vec2(-1.0,  2.0),
	vec2( 0.0,  2.0),
	vec2( 1.0,  2.0),
	vec2( 2.0,  2.0),
	vec2(-2.0,  1.0),
	vec2(-1.0,  1.0),
	vec2( 0.0,  1.0),
	vec2( 1.0,  1.0),
	vec2( 2.0,  1.0),
	vec2(-2.0,  0.0),
	vec2(-1.0,  0.0),
	vec2( 1.0,  0.0),
	vec2( 2.0,  0.0),
	vec2(-2.0, -1.0),
	vec2(-1.0, -1.0),
	vec2( 0.0, -1.0),
	vec2( 1.0, -1.0),
	vec2( 2.0, -1.0),
	vec2(-2.0, -2.0),
	vec2(-1.0, -2.0),
	vec2( 0.0, -2.0),
	vec2( 1.0, -2.0),
	vec2( 2.0, -2.0)
);

float GetHand(float depth){
	return float(depth < 0.56);
}

vec3 MotionBlur(vec3 color){
	float z = texture2D(depthtex1, texCoord.st).x;

	#ifdef BLACK_OUTLINE
	float ph = 1.0 / 1080.0;
	float pw = ph / aspectRatio;
	for(int i = 0; i < 24; i++){
		vec2 offset = vec2(pw, ph) * blackOutlineOffsets[i];
		z = min(z, texture2D(depthtex1, texCoord + offset).r);
	}
	#endif
	
	float hand = GetHand(z);

	if(hand < 0.5){
		float mbwg = 0.0;
		vec2 pixel = 2.0 / vec2(viewWidth, viewHeight);
		vec3 mblur = vec3(0.0);
		
		vec4 currentPosition = vec4(texCoord, z, 1.0) * 2.0 - 1.0;
		
		vec4 viewPos = gbufferProjectionInverse * currentPosition;
		viewPos = gbufferModelViewInverse * viewPos;
		viewPos /= viewPos.w;
		
		vec3 cameraOffset = cameraPosition - previousCameraPosition;
		
		vec4 previousPosition = viewPos + vec4(cameraOffset, 0.0);
		previousPosition = gbufferPreviousModelView * previousPosition;
		previousPosition = gbufferPreviousProjection * previousPosition;
		previousPosition /= previousPosition.w;

		vec2 velocity = (currentPosition - previousPosition).xy;
		velocity = velocity / (1.0 + length(velocity)) * MOTION_BLUR_STRENGTH * 0.02;
		
		vec2 coord = texCoord.st - velocity * (3.5 + Bayer64(gl_FragCoord.xy));
		for(int i = 0; i < 9; i++, coord += velocity){
			vec2 coordb = clamp(coord, pixel, 1.0 - pixel);
			mblur += texture2DLod(colortex0, coordb, 0.0).rgb;
			mbwg += 1.0;
		}
		mblur /= mbwg;

		return mblur;
	}
	else return color;
}