/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.tools;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.tools.Kama;

public class Scythe
extends Kama {
    public static final float DURABILITY_MODIFIER = 2.2f;

    public Scythe() {
        super(PartMaterialType.handle(TinkerTools.toughToolRod), PartMaterialType.head(TinkerTools.scytheHead), PartMaterialType.extra(TinkerTools.toughBinding), PartMaterialType.handle(TinkerTools.toughToolRod));
    }

    @Override
    public float damagePotential() {
        return 0.75f;
    }

    @Override
    public double attackSpeed() {
        return 0.9f;
    }

    @Override
    protected boolean breakBlock(ItemStack stack, BlockPos pos, EntityPlayer player) {
        return Scythe.isSilkTouch(stack) && super.breakBlock(stack, pos, player);
    }

    @Override
    protected void breakExtraBlock(ItemStack stack, World world, EntityPlayer player, BlockPos pos, BlockPos refPos) {
        if (Scythe.isSilkTouch(stack)) {
            ToolHelper.shearExtraBlock(stack, world, player, pos, refPos);
            return;
        }
        ToolHelper.breakExtraBlock(stack, world, player, pos, refPos);
    }

    @Override
    public Set<String> getToolClasses(ItemStack stack) {
        if (!Scythe.isSilkTouch(stack)) {
            return Collections.emptySet();
        }
        return super.getToolClasses(stack);
    }

    @Override
    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        if ("shears".equals(toolClass) && !Scythe.isSilkTouch(stack)) {
            return -1;
        }
        return super.getHarvestLevel(stack, toolClass, player, blockState);
    }

    private static boolean isSilkTouch(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
    }

    @Override
    public ImmutableList<BlockPos> getAOEBlocks(ItemStack stack, World world, EntityPlayer player, BlockPos origin) {
        return ToolHelper.calcAOEBlocks(stack, world, player, origin, 3, 3, 3);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity target) {
        if (player.func_184825_o(0.5f) <= 0.9f) {
            return super.onLeftClickEntity(stack, player, target);
        }
        TinkerToolEvent.ExtraBlockBreak event = TinkerToolEvent.ExtraBlockBreak.fireEvent(stack, player, player.func_130014_f_().func_180495_p(target.func_180425_c()), 3, 3, 3, -1);
        if (event.isCanceled()) {
            return false;
        }
        player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187730_dW, player.func_184176_by(), 1.0f, 1.0f);
        player.func_184810_cG();
        int distance = event.distance;
        boolean hit = false;
        for (Entity entity : this.getAoeEntities(player, target, event)) {
            if (distance >= 0 && !(entity.func_70032_d(target) <= (float)distance)) continue;
            hit |= ToolHelper.attackEntity(stack, this, (EntityLivingBase)player, entity, null, false);
        }
        if (hit) {
            player.func_184821_cY();
        }
        return hit;
    }

    private List<Entity> getAoeEntities(EntityPlayer player, Entity target, TinkerToolEvent.ExtraBlockBreak event) {
        int width = (event.width - 1) / 2;
        int height = (event.width - 1) / 2;
        AxisAlignedBB box = new AxisAlignedBB(target.field_70165_t, target.field_70163_u, target.field_70161_v, target.field_70165_t + 1.0, target.field_70163_u + 1.0, target.field_70161_v + 1.0).func_72321_a((double)width, (double)height, (double)width);
        return player.func_130014_f_().func_72839_b((Entity)player, box);
    }

    @Override
    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (!(target instanceof IShearable)) {
            return false;
        }
        TinkerToolEvent.ExtraBlockBreak event = TinkerToolEvent.ExtraBlockBreak.fireEvent(stack, player, player.func_130014_f_().func_180495_p(target.func_180425_c()), 3, 3, 3, -1);
        if (event.isCanceled()) {
            return false;
        }
        int distance = event.distance;
        boolean shorn = false;
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        for (Entity entity : this.getAoeEntities(player, (Entity)target, event)) {
            if (distance >= 0 && !(entity.func_70032_d((Entity)target) <= (float)distance)) continue;
            shorn |= this.shearEntity(stack, player.func_130014_f_(), player, entity, fortune);
        }
        if (shorn) {
            this.swingTool(player, hand);
        }
        return shorn;
    }

    @Override
    public int[] getRepairParts() {
        return new int[]{1, 2};
    }

    @Override
    public ToolNBT buildTagData(List<Material> materials) {
        HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
        HeadMaterialStats head = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        ExtraMaterialStats extra = (ExtraMaterialStats)materials.get(2).getStatsOrUnknown("extra");
        HandleMaterialStats handle2 = (HandleMaterialStats)materials.get(3).getStatsOrUnknown("handle");
        ToolNBT data = new ToolNBT();
        data.head(head);
        data.extra(extra);
        data.handle(handle, handle2);
        data.durability = (int)((float)data.durability * 2.2f);
        return data;
    }
}

