/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.ranged.item;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.BowStringMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ProjectileLauncherNBT;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.ranged.item.ShortBow;

public class LongBow
extends ShortBow {
    public static final float DURABILITY_MODIFIER = 1.4f;

    public LongBow() {
        super(PartMaterialType.bow(TinkerTools.bowLimb), PartMaterialType.bow(TinkerTools.bowLimb), PartMaterialType.extra(TinkerTools.largePlate), PartMaterialType.bowstring(TinkerTools.bowString));
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            this.addDefaultSubItems((List<ItemStack>)subItems, null, null, null, TinkerMaterials.string);
        }
    }

    @Override
    public double attackSpeed() {
        return 1.3;
    }

    @Override
    public float baseProjectileDamage() {
        return 2.5f;
    }

    @Override
    protected float baseProjectileSpeed() {
        return 5.5f;
    }

    @Override
    protected float baseInaccuracy() {
        return 1.2f;
    }

    @Override
    public float projectileDamageModifier() {
        return 1.25f;
    }

    @Override
    public int getDrawTime() {
        return 30;
    }

    @Override
    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.onUpdateTraits(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    public ProjectileLauncherNBT buildTagData(List<Material> materials) {
        ProjectileLauncherNBT data = new ProjectileLauncherNBT();
        HeadMaterialStats head1 = (HeadMaterialStats)materials.get(0).getStatsOrUnknown("head");
        HeadMaterialStats head2 = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        BowMaterialStats limb1 = (BowMaterialStats)materials.get(0).getStatsOrUnknown("bow");
        BowMaterialStats limb2 = (BowMaterialStats)materials.get(1).getStatsOrUnknown("bow");
        ExtraMaterialStats grip = (ExtraMaterialStats)materials.get(2).getStatsOrUnknown("extra");
        BowStringMaterialStats bowstring = (BowStringMaterialStats)materials.get(3).getStatsOrUnknown("bowstring");
        data.head(head1, head2);
        data.limb(limb1, limb2);
        data.extra(grip);
        data.bowstring(bowstring);
        data.durability = (int)((float)data.durability * 1.4f);
        return data;
    }
}

