/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import slimeknights.mantle.network.AbstractPacketThreadsafe;
import slimeknights.tconstruct.library.smeltery.ISmelteryTankHandler;

public class SmelteryFluidUpdatePacket
extends AbstractPacketThreadsafe {
    public BlockPos pos;
    public List<FluidStack> liquids;

    public SmelteryFluidUpdatePacket() {
    }

    public SmelteryFluidUpdatePacket(BlockPos pos, List<FluidStack> liquids) {
        this.pos = pos;
        this.liquids = liquids;
    }

    public void handleClientSafe(NetHandlerPlayClient netHandler) {
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(this.pos);
        if (te instanceof ISmelteryTankHandler) {
            ISmelteryTankHandler handler = (ISmelteryTankHandler)te;
            handler.updateFluidsFromPacket(this.liquids);
        }
    }

    public void handleServerSafe(NetHandlerPlayServer netHandler) {
        throw new UnsupportedOperationException("Clientside only");
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = this.readPos(buf);
        int size = buf.readInt();
        this.liquids = new ArrayList<FluidStack>(size);
        for (int i = 0; i < size; ++i) {
            NBTTagCompound fluidTag = ByteBufUtils.readTag((ByteBuf)buf);
            FluidStack liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
            this.liquids.add(liquid);
        }
    }

    public void toBytes(ByteBuf buf) {
        this.writePos(this.pos, buf);
        buf.writeInt(this.liquids.size());
        for (FluidStack liquid : this.liquids) {
            NBTTagCompound fluidTag = new NBTTagCompound();
            liquid.writeToNBT(fluidTag);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)fluidTag);
        }
    }
}

