/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.fluid;

import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.mantle.tileentity.MantleTileEntity;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.fluid.IFluidTankUpdater;
import slimeknights.tconstruct.smeltery.network.FluidUpdatePacket;

public class FluidTankBase<T extends MantleTileEntity>
extends FluidTank {
    protected T parent;

    public FluidTankBase(int capacity, T parent) {
        super(capacity);
        this.parent = parent;
    }

    public int fillInternal(FluidStack resource, boolean doFill) {
        int amount = super.fillInternal(resource, doFill);
        if (amount > 0 && doFill) {
            this.sendUpdate(amount);
        }
        return amount;
    }

    public FluidStack drainInternal(int maxDrain, boolean doDrain) {
        FluidStack fluid = super.drainInternal(maxDrain, doDrain);
        if (fluid != null && doDrain) {
            this.sendUpdate(-fluid.amount);
        }
        return fluid;
    }

    protected void sendUpdate(int amount) {
        if (amount != 0) {
            World world = this.parent.func_145831_w();
            if (!world.field_72995_K) {
                TinkerNetwork.sendToClients((WorldServer)world, this.parent.func_174877_v(), (AbstractPacket)new FluidUpdatePacket(this.parent.func_174877_v(), this.getFluid()));
            }
        }
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        if (this.fluid != null && this.fluid.amount > capacity) {
            this.drain(this.fluid.amount - capacity, true);
        }
    }

    protected void onContentsChanged() {
        if (this.parent instanceof IFluidTankUpdater) {
            ((IFluidTankUpdater)this.parent).onTankContentsChanged();
        }
        this.parent.markDirtyFast();
    }
}

