/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.texture;

import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.client.texture.AbstractColoredTexture;

public class SimpleColoredTexture
extends AbstractColoredTexture {
    protected final int colorLow;
    protected final int colorMid;
    protected final int colorHigh;
    protected int minBrightness;
    protected int maxBrightness;
    protected int[] brightnessData;

    public SimpleColoredTexture(int colorLow, int colorMid, int colorHigh, ResourceLocation baseTexture, String spriteName) {
        super(baseTexture, spriteName);
        this.colorLow = colorLow;
        this.colorMid = colorMid;
        this.colorHigh = colorHigh;
    }

    @Override
    protected void preProcess(int[] data) {
        int max = 0;
        int min = 255;
        this.brightnessData = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            int pixel = data[i];
            if (RenderUtil.alpha(pixel) == 0) continue;
            int brightness = SimpleColoredTexture.getPerceptualBrightness(pixel);
            if (brightness < min) {
                min = brightness;
            }
            if (brightness > max) {
                max = brightness;
            }
            this.brightnessData[i] = brightness;
        }
        int brightnessDiff = max - min;
        this.minBrightness = Math.max(min + 1, min + (int)((float)(brightnessDiff /= 2) * 0.4f));
        this.maxBrightness = Math.min(max - 1, max - (int)((float)brightnessDiff * 0.3f));
    }

    @Override
    protected void postProcess(int[] data) {
        this.brightnessData = null;
    }

    @Override
    protected int colorPixel(int pixel, int pxCoord) {
        int a = RenderUtil.alpha(pixel);
        if (a == 0) {
            return pixel;
        }
        int brightness = this.brightnessData[pxCoord];
        int c = this.colorMid;
        if (brightness < this.minBrightness) {
            c = this.colorLow;
        } else if (brightness > this.maxBrightness) {
            c = this.colorHigh;
        }
        int r = RenderUtil.red(c);
        int b = RenderUtil.blue(c);
        int g = RenderUtil.green(c);
        r = SimpleColoredTexture.mult(r, RenderUtil.red(pixel)) & 0xFF;
        g = SimpleColoredTexture.mult(g, RenderUtil.blue(pixel)) & 0xFF;
        b = SimpleColoredTexture.mult(b, RenderUtil.green(pixel)) & 0xFF;
        return RenderUtil.compose(r, g, b, a);
    }
}

