/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.book.content;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.gui.book.GuiBook;
import slimeknights.mantle.client.gui.book.element.BookElement;
import slimeknights.mantle.client.gui.book.element.ElementItem;
import slimeknights.mantle.client.gui.book.element.ElementText;
import slimeknights.mantle.util.LocUtils;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.book.TinkerPage;
import slimeknights.tconstruct.library.book.elements.ElementTinkerItem;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockCasting;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.common.block.BlockToolTable;
import slimeknights.tconstruct.tools.harvest.TinkerHarvestTools;
import slimeknights.tconstruct.tools.melee.TinkerMeleeWeapons;
import slimeknights.tconstruct.tools.ranged.TinkerRangedWeapons;

@SideOnly(value=Side.CLIENT)
public class ContentMaterial
extends TinkerPage {
    public static final String ID = "toolmaterial";
    private transient Material material;
    @SerializedName(value="material")
    public String materialName;

    public ContentMaterial(Material material) {
        this.material = material;
        this.materialName = material.getIdentifier();
    }

    public void load() {
        if (this.material == null) {
            this.material = TinkerRegistry.getMaterial(this.materialName);
        }
    }

    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        this.addTitle(list, this.material.getLocalizedNameColored(), true);
        this.addDisplayItems(list, rightSide ? GuiBook.PAGE_WIDTH - 18 : 0);
        int col_margin = 22;
        int top = 15;
        int left = rightSide ? 0 : col_margin;
        int y = top + 10;
        int x = left + 10;
        int w = GuiBook.PAGE_WIDTH / 2 - 10;
        LinkedHashSet<ITrait> allTraits = new LinkedHashSet<ITrait>();
        this.addStatsDisplay(x, y, w, list, allTraits, "head");
        this.addStatsDisplay(x + w, y, w - 10, list, allTraits, "handle");
        this.addStatsDisplay(x, y += 65 + 10 * this.material.getAllTraitsForStats("head").size(), w, list, allTraits, "extra");
        String flavour = (String)this.parent.parent.parent.strings.get(String.format("%s.flavour", this.material.getIdentifier()));
        if (flavour != null) {
            TextData flavourData = new TextData("\"" + flavour + "\"");
            flavourData.italic = true;
            list.add((BookElement)new ElementText(x + w, y, w - 16, 60, new TextData[]{flavourData}));
        }
    }

    private void addStatsDisplay(int x, int y, int w, ArrayList<BookElement> list, LinkedHashSet<ITrait> allTraits, String stattype) {
        Object stats = this.material.getStats(stattype);
        if (stats == null) {
            return;
        }
        List<ITrait> traits = this.material.getAllTraitsForStats(stats.getIdentifier());
        allTraits.addAll(traits);
        LinkedList parts = Lists.newLinkedList();
        for (IToolPart part : TinkerRegistry.getToolParts()) {
            if (!part.hasUseForStat(stats.getIdentifier())) continue;
            parts.add(part.getItemstackWithMaterial(this.material));
        }
        if (parts.size() > 0) {
            ElementTinkerItem display = new ElementTinkerItem(x, y + 1, 0.5f, parts);
            list.add((BookElement)display);
        }
        ElementText name = new ElementText(x + 10, y, w - 10, 10, stats.getLocalizedName());
        name.text[0].underlined = true;
        list.add((BookElement)name);
        y += 12;
        ArrayList lineData = Lists.newArrayList();
        lineData.addAll(ContentMaterial.getStatLines(stats));
        lineData.addAll(ContentMaterial.getTraitLines(traits, this.material));
        list.add((BookElement)new ElementText(x, y, w, GuiBook.PAGE_HEIGHT, (Collection)lineData));
    }

    public static List<TextData> getStatLines(IMaterialStats stats) {
        ArrayList<TextData> lineData = new ArrayList<TextData>();
        for (int i = 0; i < stats.getLocalizedInfo().size(); ++i) {
            TextData text = new TextData(stats.getLocalizedInfo().get(i));
            text.tooltip = LocUtils.convertNewlines((String)stats.getLocalizedDesc().get(i)).split("\n");
            lineData.add(text);
            lineData.add(new TextData("\n"));
        }
        return lineData;
    }

    public static List<TextData> getTraitLines(List<ITrait> traits, Material material) {
        ArrayList<TextData> lineData = new ArrayList<TextData>();
        for (ITrait trait : traits) {
            TextData text = new TextData(trait.getLocalizedName());
            text.tooltip = LocUtils.convertNewlines((String)(material.getTextColor() + trait.getLocalizedDesc())).split("\n");
            text.color = TextFormatting.DARK_GRAY.func_96297_d();
            text.underlined = true;
            lineData.add(text);
            lineData.add(new TextData("\n"));
        }
        return lineData;
    }

    private void addDisplayItems(ArrayList<BookElement> list, int x) {
        ElementTinkerItem elementItem;
        ArrayList displayTools = Lists.newArrayList();
        int y = 10;
        if (!this.material.getRepresentativeItem().func_190926_b()) {
            displayTools.add(new ElementTinkerItem(this.material.getRepresentativeItem()));
        }
        if (this.material.isCraftable()) {
            ItemStack partbuilder = new ItemStack((Block)TinkerTools.toolTables, 1, BlockToolTable.TableTypes.PartBuilder.meta);
            elementItem = new ElementTinkerItem(partbuilder);
            elementItem.tooltip = ImmutableList.of((Object)this.parent.translate("material.craft_partbuilder"));
            displayTools.add(elementItem);
        }
        if (this.material.isCastable()) {
            ItemStack basin = new ItemStack((Block)TinkerSmeltery.castingBlock, 1, BlockCasting.CastingType.BASIN.getMeta());
            elementItem = new ElementTinkerItem(basin);
            String text = this.parent.translate("material.craft_casting");
            elementItem.tooltip = ImmutableList.of((Object)String.format(text, this.material.getFluid().getLocalizedName(new FluidStack(this.material.getFluid(), 0))));
            displayTools.add(elementItem);
        }
        ToolCore[] tools = new ToolCore[]{TinkerHarvestTools.pickaxe, TinkerHarvestTools.mattock, TinkerMeleeWeapons.broadSword, TinkerHarvestTools.hammer, TinkerMeleeWeapons.cleaver, TinkerRangedWeapons.shuriken, TinkerMeleeWeapons.fryPan, TinkerHarvestTools.lumberAxe, TinkerMeleeWeapons.battleSign};
        for (ToolCore tool : tools) {
            if (tool == null) continue;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < tool.getRequiredComponents().size(); ++i) {
                builder.add((Object)this.material);
            }
            ItemStack builtTool = tool.buildItem((List<Material>)builder.build());
            if (tool.hasValidMaterials(builtTool)) {
                displayTools.add(new ElementTinkerItem(builtTool));
            }
            if (displayTools.size() == 9) break;
        }
        if (!displayTools.isEmpty()) {
            for (ElementItem element : displayTools) {
                element.x = x;
                element.y = y;
                element.scale = 1.0f;
                y += 16;
                list.add((BookElement)element);
            }
        }
    }
}

