/*
 * Decompiled with CFR 0.152.
 */
package teamroots.emberroot.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class Util {
    public static Random random = new Random();
    public static ArrayList<IBlockState> oreList = new ArrayList();
    public static ArrayList<Block> naturalBlocks = new ArrayList();

    public static double randomDouble(double min, double max) {
        double range = max - min;
        double scale = random.nextDouble() * range;
        double shifted = scale + min;
        return shifted;
    }

    public static float fastSin(float x) {
        if ((double)x < -3.14159265) {
            x = (float)((double)x + 6.28318531);
        } else if ((double)x > 3.14159265) {
            x = (float)((double)x - 6.28318531);
        }
        if (x < 0.0f) {
            return (float)(1.27323954 * (double)x + 0.405284735 * (double)x * (double)x);
        }
        return (float)(1.27323954 * (double)x - 0.405284735 * (double)x * (double)x);
    }

    public static float fastCos(float x) {
        if ((double)x < -3.14159265) {
            x = (float)((double)x + 6.28318531);
        } else if ((double)x > 3.14159265) {
            x = (float)((double)x - 6.28318531);
        }
        x = (float)((double)x + 1.57079632);
        if ((double)x > 3.14159265) {
            x = (float)((double)x - 6.28318531);
        }
        if (x < 0.0f) {
            return (float)(1.27323954 * (double)x + 0.405284735 * (double)x * (double)x);
        }
        return (float)(1.27323954 * (double)x - 0.405284735 * (double)x * (double)x);
    }

    public static boolean hasOreDictPrefix(ItemStack stack, String dict) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        for (int i = 0; i < ids.length; ++i) {
            if (OreDictionary.getOreName((int)ids[i]).length() < dict.length() || OreDictionary.getOreName((int)ids[i]).substring(0, dict.length()).compareTo(dict.substring(0, dict.length())) != 0) continue;
            return true;
        }
        return false;
    }

    public static float yawDegreesBetweenPointsSafe(double posX, double posY, double posZ, double posX2, double posY2, double posZ2, double previousYaw) {
        float f = (float)(180.0 * Math.atan2(posX2 - posX, posZ2 - posZ) / 3.1415927410125732);
        if (Math.abs((double)f - previousYaw) > 90.0) {
            f = (double)f < previousYaw ? (float)((double)f + 360.0) : (float)((double)f - 360.0);
        }
        return f;
    }

    public static float yawDegreesBetweenPoints(double posX, double posY, double posZ, double posX2, double posY2, double posZ2) {
        float f = (float)(180.0 * Math.atan2(posX2 - posX, posZ2 - posZ) / 3.1415927410125732);
        return f;
    }

    public static Vec3d lookVector(float rotYaw, float rotPitch) {
        return new Vec3d(Math.sin(rotYaw) * Math.cos(rotPitch), Math.sin(rotPitch), Math.cos(rotYaw) * Math.cos(rotPitch));
    }

    public static float interpolateYawDegrees(float angle1, float ratio1, float angle2, float ratio2) {
        if (Math.abs(angle1 - angle2) > 180.0f) {
            if (angle2 > angle1) {
                angle2 -= 360.0f;
            } else {
                angle1 -= 360.0f;
            }
        }
        return angle1 * ratio1 + angle2 * ratio2;
    }

    public static float pitchDegreesBetweenPoints(double posX, double posY, double posZ, double posX2, double posY2, double posZ2) {
        return (float)Math.toDegrees(Math.atan2(posY2 - posY, Math.sqrt((posX2 - posX) * (posX2 - posX) + (posZ2 - posZ) * (posZ2 - posZ))));
    }

    public static double interpolate(float s, float e, float t) {
        double t2 = (1.0 - (double)Util.fastCos(t * (float)Math.PI)) / 2.0;
        return (double)s * (1.0 - t2) + (double)e * t2;
    }

    public static BlockPos getRayTrace(World world, EntityPlayer player, int reachDistance) {
        double x = player.field_70165_t;
        double y = player.field_70163_u + (double)player.func_70047_e();
        double z = player.field_70161_v;
        int i = 0;
        while ((double)i < (double)reachDistance * 4.0) {
            if (world.func_180495_p(new BlockPos(x += player.func_70040_Z().field_72450_a * 0.25, y += player.func_70040_Z().field_72448_b * 0.25, z += player.func_70040_Z().field_72449_c * 0.25)).func_185917_h()) {
                return new BlockPos(x, y, z);
            }
            ++i;
        }
        return new BlockPos(x, y, z);
    }

    public static BlockPos getRayTraceNonFull(World world, EntityPlayer player, int reachDistance) {
        double x = player.field_70165_t;
        double y = player.field_70163_u + (double)player.func_70047_e();
        double z = player.field_70161_v;
        int i = 0;
        while ((double)i < (double)reachDistance * 4.0) {
            if (!world.func_175623_d(new BlockPos(x += player.func_70040_Z().field_72450_a * 0.25, y += player.func_70040_Z().field_72448_b * 0.25, z += player.func_70040_Z().field_72449_c * 0.25))) {
                return new BlockPos(x, y, z);
            }
            ++i;
        }
        return new BlockPos(x, y, z);
    }

    public static Entity getRayTraceEntity(World world, EntityPlayer player, int reachDistance) {
        double x = player.field_70165_t;
        double y = player.field_70163_u + (double)player.func_70047_e();
        double z = player.field_70161_v;
        int i = 0;
        while ((double)i < (double)reachDistance * 100.0) {
            List entities;
            if ((entities = world.func_72872_a(Entity.class, new AxisAlignedBB((x += player.func_70040_Z().field_72450_a * 0.01) - 0.1, (y += player.func_70040_Z().field_72448_b * 0.01) - 0.1, (z += player.func_70040_Z().field_72449_c * 0.01) - 0.1, x + 0.1, y + 0.1, z + 0.1))).size() > 0 && ((Entity)entities.get(0)).func_110124_au() != player.func_110124_au()) {
                return (Entity)entities.get(0);
            }
            ++i;
        }
        return null;
    }

    public static void initOres() {
        oreList.add(Blocks.field_150366_p.func_176223_P());
        oreList.add(Blocks.field_150352_o.func_176223_P());
        oreList.add(Blocks.field_150482_ag.func_176223_P());
        oreList.add(Blocks.field_150450_ax.func_176223_P());
        oreList.add(Blocks.field_150369_x.func_176223_P());
        oreList.add(Blocks.field_150365_q.func_176223_P());
    }

    public static void initNaturalBlocks() {
        naturalBlocks.add((Block)Blocks.field_150329_H);
        naturalBlocks.add((Block)Blocks.field_150349_c);
        naturalBlocks.add(Blocks.field_185774_da);
        naturalBlocks.add((Block)Blocks.field_150362_t);
        naturalBlocks.add(Blocks.field_150364_r);
        naturalBlocks.add(Blocks.field_150363_s);
        naturalBlocks.add(Blocks.field_150344_f);
        naturalBlocks.add((Block)Blocks.field_150434_aF);
        naturalBlocks.add(Blocks.field_150392_bi);
        naturalBlocks.add((Block)Blocks.field_150355_j);
        naturalBlocks.add((Block)Blocks.field_150358_i);
        naturalBlocks.add((Block)Blocks.field_150328_O);
        naturalBlocks.add((Block)Blocks.field_150327_N);
    }

    public static boolean containsItem(List<ItemStack> list, Item item) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null || list.get(i).func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean containsItem(List<ItemStack> list, Block item) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null || Block.func_149634_a((Item)list.get(i).func_77973_b()) != item) continue;
            return true;
        }
        return false;
    }

    public static boolean containsItem(List<ItemStack> list, Item item, int meta) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null || list.get(i).func_77973_b() != item || list.get(i).func_77960_j() != meta) continue;
            return true;
        }
        return false;
    }

    public static boolean containsItem(List<ItemStack> list, Block item, int meta) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null || Block.func_149634_a((Item)list.get(i).func_77973_b()) != item || list.get(i).func_77960_j() != meta) continue;
            return true;
        }
        return false;
    }

    public static IBlockState getRandomOre() {
        return oreList.get(random.nextInt(oreList.size()));
    }

    public static boolean oreDictMatches(ItemStack stack1, ItemStack stack2) {
        if (OreDictionary.itemMatches((ItemStack)stack1, (ItemStack)stack2, (boolean)true)) {
            return true;
        }
        int[] oreIds = OreDictionary.getOreIDs((ItemStack)stack1);
        for (int i = 0; i < oreIds.length; ++i) {
            if (!OreDictionary.containsMatch((boolean)true, (NonNullList)OreDictionary.getOres((String)OreDictionary.getOreName((int)oreIds[i])), (ItemStack[])new ItemStack[]{stack2})) continue;
            return true;
        }
        return false;
    }

    public static int intColor(int r, int g, int b) {
        return r * 65536 + g * 256 + b;
    }

    public static boolean isNaturalBlock(Block block) {
        for (int i = 0; i < naturalBlocks.size(); ++i) {
            if (naturalBlocks.get(i) != block) continue;
            return true;
        }
        return false;
    }

    public static boolean itemListsMatchWithSize(List<ItemStack> i1, List<ItemStack> i2) {
        int i;
        ArrayList<ItemStack> recipe = new ArrayList<ItemStack>();
        ArrayList<ItemStack> available = new ArrayList<ItemStack>();
        recipe.addAll(i1);
        available.addAll(i2);
        for (i = 0; i < recipe.size(); ++i) {
            if (recipe.get(i) != null) continue;
            recipe.remove(i);
            --i;
        }
        for (i = 0; i < available.size(); ++i) {
            if (available.get(i) != null) continue;
            available.remove(i);
            --i;
        }
        if (available.size() == recipe.size()) {
            for (int j = 0; j < available.size(); ++j) {
                boolean endIteration = false;
                for (int i3 = 0; i3 < recipe.size() && !endIteration; ++i3) {
                    if (!Util.oreDictMatches((ItemStack)available.get(j), (ItemStack)recipe.get(i3))) continue;
                    recipe.remove(i3);
                    endIteration = true;
                }
            }
        }
        return recipe.size() == 0;
    }

    public static float fract(float f) {
        return f - (float)((int)f);
    }

    public static double fract(double d) {
        return d - (double)((int)d);
    }

    public static boolean itemListsMatch(List<ItemStack> i1, List<ItemStack> i2) {
        int i;
        ArrayList<ItemStack> recipe = new ArrayList<ItemStack>();
        ArrayList<ItemStack> available = new ArrayList<ItemStack>();
        recipe.addAll(i1);
        available.addAll(i2);
        for (i = 0; i < recipe.size(); ++i) {
            if (recipe.get(i) != null) continue;
            recipe.remove(i);
            --i;
        }
        for (i = 0; i < available.size(); ++i) {
            if (available.get(i) != null) continue;
            available.remove(i);
            --i;
        }
        if (available.size() >= recipe.size()) {
            for (int j = 0; j < available.size(); ++j) {
                boolean endIteration = false;
                for (int i3 = 0; i3 < recipe.size() && !endIteration; ++i3) {
                    if (!Util.oreDictMatches((ItemStack)available.get(j), (ItemStack)recipe.get(i3))) continue;
                    recipe.remove(i3);
                    endIteration = true;
                }
            }
        }
        return recipe.size() == 0;
    }

    public static float getNatureAmount(IBlockState state) {
        if (state.func_177230_c() == Blocks.field_150346_d) {
            return 0.04f;
        }
        if (state.func_177230_c() == Blocks.field_150349_c) {
            return 0.16f;
        }
        if (state.func_177230_c() == Blocks.field_150329_H) {
            return 0.24f;
        }
        if (state.func_177230_c() == Blocks.field_150328_O) {
            return 0.64f;
        }
        if (state.func_177230_c() == Blocks.field_150327_N) {
            return 0.64f;
        }
        if (state.func_177230_c() == Blocks.field_150398_cm) {
            return 0.8f;
        }
        if (state.func_177230_c() == Blocks.field_150355_j) {
            return 0.16f;
        }
        if (state.func_177230_c() == Blocks.field_150362_t || state.func_177230_c() == Blocks.field_150361_u) {
            return 0.32f;
        }
        if (state.func_177230_c() == Blocks.field_150364_r || state.func_177230_c() == Blocks.field_150363_s) {
            return 0.24f;
        }
        if (state.func_177230_c() == Blocks.field_150392_bi) {
            return 0.56f;
        }
        if (state.func_177230_c() == Blocks.field_150434_aF) {
            return 0.72f;
        }
        return 0.0f;
    }

    public static EnumFacing getRayFace(World world, EntityPlayer player, int reachDistance) {
        double x = player.field_70165_t;
        double y = player.field_70163_u + (double)player.func_70047_e();
        double z = player.field_70161_v;
        int i = 0;
        while ((double)i < (double)reachDistance * 4.0) {
            if (world.func_180495_p(new BlockPos(x += player.func_70040_Z().field_72450_a * 0.25, y += player.func_70040_Z().field_72448_b * 0.25, z += player.func_70040_Z().field_72449_c * 0.25)).func_185917_h()) {
                BlockPos pos = new BlockPos(x, y, z);
                double centerX = (double)pos.func_177958_n() + 0.5;
                double centerY = (double)pos.func_177956_o() + 0.5;
                double centerZ = (double)pos.func_177952_p() + 0.5;
                double dx = Math.abs(x - centerX);
                double dy = Math.abs(y - centerY);
                double dz = Math.abs(z - centerZ);
                if (dx > dy && dx > dz) {
                    if (x - centerX > 0.0) {
                        return EnumFacing.EAST;
                    }
                    return EnumFacing.WEST;
                }
                if (dy > dz) {
                    if (y - centerY > 0.0) {
                        return EnumFacing.UP;
                    }
                    return EnumFacing.DOWN;
                }
                if (z - centerZ > 0.0) {
                    return EnumFacing.SOUTH;
                }
                return EnumFacing.NORTH;
            }
            ++i;
        }
        return EnumFacing.UP;
    }
}

