/*
 * Decompiled with CFR 0.152.
 */
package teamroots.emberroot.entity.golem;

import java.awt.Color;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import teamroots.emberroot.config.ConfigSpawnEntity;
import teamroots.emberroot.entity.deer.EntityDeer;
import teamroots.emberroot.entity.golem.EntityGolemLaser;

public class EntityAncientGolem
extends EntityMob {
    public static final DataParameter<Integer> variant = EntityDataManager.func_187226_a(EntityAncientGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> FIRESPEED = EntityDataManager.func_187226_a(EntityAncientGolem.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final String NAME = "rainbow_golem";
    public static ConfigSpawnEntity config = new ConfigSpawnEntity(EntityAncientGolem.class, EnumCreatureType.MONSTER);
    public static boolean attacksSomeMobs;

    public EntityAncientGolem(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.8f);
        this.field_70728_aV = 10;
    }

    public Integer getVariant() {
        return (Integer)this.func_184212_Q().func_187225_a(variant);
    }

    public VariantColors getVariantEnum() {
        return VariantColors.values()[this.getVariant()];
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(FIRESPEED, (Object)MathHelper.func_76136_a((Random)this.field_70146_Z, (int)40, (int)110));
        this.func_184212_Q().func_187214_a(variant, (Object)this.field_70146_Z.nextInt(VariantColors.values().length));
        switch (this.getVariantEnum()) {
            case ORANGE: 
            case PURPLE: 
            case RED: {
                this.field_70178_ae = true;
                break;
            }
            default: {
                this.field_70178_ae = false;
            }
        }
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        String var = this.getVariantEnum().nameLower();
        return I18n.func_74838_a((String)("entity." + s + "." + var + ".name"));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.46, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.46));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.46));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        if (attacksSomeMobs) {
            switch (this.getVariantEnum()) {
                case BLUE: {
                    this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySlime.class, true));
                    break;
                }
                case GREEN: {
                    this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, true));
                    break;
                }
                case ORANGE: {
                    this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySkeleton.class, true));
                    break;
                }
                case PURPLE: {
                    this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityEnderman.class, true));
                    break;
                }
                case RED: {
                    this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPigZombie.class, true));
                    break;
                }
                case YELLOW: {
                    this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityDeer.class, true));
                    break;
                }
            }
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        ConfigSpawnEntity.syncInstance((EntityLivingBase)this, EntityAncientGolem.config.settings);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70177_z = this.field_70759_as;
        if (this.field_70173_aa % (Integer)this.func_184212_Q().func_187225_a(FIRESPEED) == 0 && this.func_70638_az() != null && !this.func_130014_f_().field_72995_K) {
            EntityGolemLaser proj = new EntityGolemLaser(this.func_130014_f_());
            proj.func_184212_Q().func_187227_b(EntityGolemLaser.variant, (Object)this.getVariant());
            proj.initCustom(this.field_70165_t, this.field_70163_u + 1.6, this.field_70161_v, this.func_70040_Z().field_72450_a * 0.5, this.func_70040_Z().field_72448_b * 0.5, this.func_70040_Z().field_72449_c * 0.5, 4.0, this.func_110124_au());
            this.func_130014_f_().func_72838_d((Entity)proj);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_184212_Q().func_187227_b(variant, (Object)compound.func_74762_e("variant"));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("variant", ((Integer)this.func_184212_Q().func_187225_a(variant)).intValue());
    }

    public ResourceLocation func_184647_J() {
        return new ResourceLocation("emberroot", "entity/golem_" + this.getVariantEnum().nameLower());
    }

    public static enum VariantColors {
        RED,
        ORANGE,
        YELLOW,
        GREEN,
        BLUE,
        PURPLE;


        public String nameLower() {
            return this.name().toLowerCase();
        }

        public Color getColor() {
            switch (this) {
                case BLUE: {
                    return new Color(0, 173, 255);
                }
                case GREEN: {
                    return new Color(57, 255, 56);
                }
                case ORANGE: {
                    return new Color(255, 64, 16);
                }
                case PURPLE: {
                    return new Color(255, 56, 249);
                }
                case RED: {
                    return new Color(179, 3, 2);
                }
                case YELLOW: {
                    return new Color(227, 225, 2);
                }
            }
            return null;
        }
    }
}

