/*
 * Decompiled with CFR 0.152.
 */
package teamroots.emberroot.entity.fairy;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.emberroot.EmberRootZoo;
import teamroots.emberroot.config.ConfigSpawnEntity;
import teamroots.emberroot.entity.ai.EntityAITemptFlying;
import teamroots.emberroot.entity.fairy.ParticleFairyGlow;
import teamroots.emberroot.proxy.ClientProxy;

public class EntityFairy
extends EntityFlying {
    public static final DataParameter<Integer> variant = EntityDataManager.func_187226_a(EntityFairy.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<BlockPos> spawnPosition = EntityDataManager.func_187226_a(EntityFairy.class, (DataSerializer)DataSerializers.field_187200_j);
    public static final DataParameter<BlockPos> targetPosition = EntityDataManager.func_187226_a(EntityFairy.class, (DataSerializer)DataSerializers.field_187200_j);
    public static final DataParameter<Boolean> tame = EntityDataManager.func_187226_a(EntityFairy.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityFairy.class, (DataSerializer)DataSerializers.field_187203_m);
    public static final String NAME = "fairies";
    public static Random random = new Random();
    public static int counter = 0;
    public static ConfigSpawnEntity config = new ConfigSpawnEntity(EntityFairy.class, EnumCreatureType.CREATURE);
    public static boolean tameWithGlowstone;

    public EntityFairy(World world) {
        super(world);
        this.func_70105_a(0.45f, 0.6f);
        this.field_70728_aV = 10;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAITemptFlying((EntityLiving)this, 66.95, Items.field_151114_aO, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public void setOwnerId(@Nullable UUID u) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)u));
    }

    @Nullable
    public UUID getOwnerId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setTamed(boolean tamed) {
        this.func_184212_Q().func_187227_b(tame, (Object)tamed);
    }

    public boolean isTamed() {
        return (Boolean)this.func_184212_Q().func_187225_a(tame);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (tameWithGlowstone && player.func_184586_b(hand).func_185136_b(new ItemStack(Items.field_151114_aO))) {
            if (this.isTamed()) {
                this.func_184212_Q().func_187227_b(tame, (Object)false);
                this.setOwnerId(null);
                if (player.field_70170_p.field_72995_K) {
                    this.playUnTameEffect(7);
                }
            } else {
                this.func_184212_Q().func_187227_b(tame, (Object)true);
                this.setOwnerId(player.func_110124_au());
                this.func_184212_Q().func_187217_b(tame);
                if (player.field_70170_p.field_72995_K) {
                    this.playTameEffect(7);
                }
                player.func_184586_b(hand).func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    protected void playTameEffect(int count) {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
        for (int i = 0; i < count; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void playUnTameEffect(int count) {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.SMOKE_LARGE;
        for (int i = 0; i < count; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    public Integer getVariant() {
        return (Integer)this.func_184212_Q().func_187225_a(variant);
    }

    public VariantColors getVariantEnum() {
        return VariantColors.values()[this.getVariant()];
    }

    public float getRed() {
        return this.getVariantEnum().red();
    }

    public float getGreen() {
        return this.getVariantEnum().green();
    }

    public float getBlue() {
        return this.getVariantEnum().blue();
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                float x = (float)this.field_70165_t + 0.25f * (this.field_70146_Z.nextFloat() - 0.5f);
                float y = (float)this.field_70163_u + 0.375f + 0.25f * (this.field_70146_Z.nextFloat() - 0.5f);
                float z = (float)this.field_70161_v + 0.25f * (this.field_70146_Z.nextFloat() - 0.5f);
                EntityFairy.spawnParticleGlow(this.field_70170_p, x, y, z, 0.0375f * (this.field_70146_Z.nextFloat() - 0.5f), 0.0375f * (this.field_70146_Z.nextFloat() - 0.5f), 0.0375f * (this.field_70146_Z.nextFloat() - 0.5f), this.getRed(), this.getGreen(), this.getBlue(), 0.125f, 6.0f + 6.0f * this.field_70146_Z.nextFloat(), 20);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnParticleGlow(World world, float x, float y, float z, float vx, float vy, float vz, float r, float g, float b, float a, float scale, int lifetime) {
        if (EmberRootZoo.proxy instanceof ClientProxy && (counter += random.nextInt(3)) % (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 0 ? 1 : 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa) == 0) {
            ClientProxy.particleRenderer.addParticle(new ParticleFairyGlow(world, x, y, z, vx, vy, vz, r, g, b, a, scale, lifetime));
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        UUID owner = this.getOwnerId();
        if (((Boolean)this.func_184212_Q().func_187225_a(tame)).booleanValue() && owner != null && this.field_70170_p.func_152378_a(owner) != null) {
            EntityPlayer p = this.field_70170_p.func_152378_a(owner);
            if (!p.func_70093_af()) {
                double targX = p.field_70165_t;
                double targY = p.field_70163_u + (double)p.field_70131_O;
                double targZ = p.field_70161_v;
                int count = 1;
                double followRange = EntityFairy.config.settings.followRange;
                if (this.func_70068_e((Entity)p) < followRange) {
                    List list = this.field_70170_p.func_72872_a(EntityFairy.class, p.func_174813_aQ().func_72321_a(followRange, followRange, followRange));
                    ArrayList<EntityFairy> prunedList = new ArrayList<EntityFairy>();
                    for (EntityFairy f : list) {
                        if (!((Boolean)f.func_184212_Q().func_187225_a(tame)).booleanValue() || f.getOwnerId() == null || f.getOwnerId().compareTo(p.func_110124_au()) != 0) continue;
                        prunedList.add(f);
                    }
                    for (int i = 0; i < prunedList.size(); ++i) {
                        if (((EntityFairy)((Object)prunedList.get(i))).func_110124_au().compareTo(this.func_110124_au()) == 0) {
                            float coeff = (float)i / (float)prunedList.size();
                            if (prunedList.size() > 1) {
                                coeff = (float)i / ((float)prunedList.size() - 1.0f);
                            }
                            targX = p.field_70165_t + (double)p.field_70130_N * 1.5 * Math.sin(Math.toRadians((double)(-p.field_70177_z) - 90.0 - 180.0 * (double)coeff));
                            targY = p.field_70163_u + (double)p.field_70131_O;
                            targZ = p.field_70161_v + (double)p.field_70130_N * 1.5 * Math.cos(Math.toRadians((double)(-p.field_70177_z) - 90.0 - 180.0 * (double)coeff));
                            continue;
                        }
                        if (((EntityFairy)((Object)prunedList.get(i))).func_184212_Q().func_187225_a(variant) != this.func_184212_Q().func_187225_a(variant)) continue;
                        ++count;
                    }
                }
                double dX = targX - this.field_70165_t;
                double dY = targY - this.field_70163_u;
                double dZ = targZ - this.field_70161_v;
                double c = p.func_70093_af() ? 0.3 : 1.0;
                this.field_70159_w += (Math.signum(dX) * (double)1.4f * c - this.field_70159_w) * 0.025;
                this.field_70181_x += (Math.signum(dY) * (double)2.2f * c - this.field_70181_x) * 0.025;
                this.field_70179_y += (Math.signum(dZ) * (double)1.4f * c - this.field_70179_y) * 0.025;
                float f = (float)(MathHelper.func_181159_b((double)this.field_70179_y, (double)this.field_70159_w) * 57.29577951308232) - 90.0f;
                float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
                this.field_191988_bg = 0.5f;
                this.field_70177_z += f1;
            }
        } else {
            this.field_70145_X = false;
            if (((BlockPos)this.func_184212_Q().func_187225_a(spawnPosition)).func_177956_o() < 0) {
                this.func_184212_Q().func_187227_b(spawnPosition, (Object)this.func_180425_c());
                this.func_184212_Q().func_187217_b(spawnPosition);
                this.func_184212_Q().func_187227_b(targetPosition, (Object)this.func_180425_c());
                this.func_184212_Q().func_187217_b(targetPosition);
            }
            if (((BlockPos)this.func_184212_Q().func_187225_a(targetPosition)).compareTo((Vec3i)this.func_184212_Q().func_187225_a(spawnPosition)) == 0 || this.field_70146_Z.nextInt(30) == 0 || ((BlockPos)this.func_184212_Q().func_187225_a(targetPosition)).func_177954_c((double)((int)this.field_70165_t), (double)((int)this.field_70163_u), (double)((int)this.field_70161_v)) < 3.0) {
                this.func_184212_Q().func_187227_b(targetPosition, (Object)new BlockPos(((BlockPos)this.func_184212_Q().func_187225_a(spawnPosition)).func_177958_n() + this.field_70146_Z.nextInt(15) - this.field_70146_Z.nextInt(15), ((BlockPos)this.func_184212_Q().func_187225_a(spawnPosition)).func_177956_o() + this.field_70146_Z.nextInt(11) - 2, ((BlockPos)this.func_184212_Q().func_187225_a(spawnPosition)).func_177952_p() + this.field_70146_Z.nextInt(15) - this.field_70146_Z.nextInt(15)));
                this.func_184212_Q().func_187217_b(targetPosition);
            }
            double dX = (double)((BlockPos)this.func_184212_Q().func_187225_a(targetPosition)).func_177958_n() + 0.5 - this.field_70165_t;
            double dY = (double)((BlockPos)this.func_184212_Q().func_187225_a(targetPosition)).func_177956_o() + 0.1 - this.field_70163_u;
            double dZ = (double)((BlockPos)this.func_184212_Q().func_187225_a(targetPosition)).func_177952_p() + 0.5 - this.field_70161_v;
            this.field_70159_w += (Math.signum(dX) * 0.5 - this.field_70159_w) * 0.025;
            this.field_70181_x += (Math.signum(dY) * 0.7 - this.field_70181_x) * 0.025;
            this.field_70179_y += (Math.signum(dZ) * 0.5 - this.field_70179_y) * 0.025;
            float f = (float)(MathHelper.func_181159_b((double)this.field_70179_y, (double)this.field_70159_w) * 57.29577951308232) - 90.0f;
            float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
            this.field_191988_bg = 0.5f;
            this.field_70177_z += f1;
        }
    }

    public boolean func_145773_az() {
        return true;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
        this.func_184212_Q().func_187214_a(tame, (Object)false);
        this.func_184212_Q().func_187214_a(variant, (Object)this.field_70146_Z.nextInt(VariantColors.values().length));
        this.func_184212_Q().func_187214_a(spawnPosition, (Object)new BlockPos(0, -1, 0));
        this.func_184212_Q().func_187214_a(targetPosition, (Object)new BlockPos(0, -1, 0));
    }

    public boolean func_175446_cd() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        ConfigSpawnEntity.syncInstance((EntityLivingBase)this, EntityFairy.config.settings);
    }

    public ResourceLocation func_184647_J() {
        String colour = this.getVariantEnum().nameLower();
        return new ResourceLocation("emberroot", "entity/fairy_" + colour);
    }

    public float func_70047_e() {
        return this.field_70131_O;
    }

    public int func_70070_b() {
        return 255;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        String s = "";
        if (compound.func_150297_b("OwnerUUID", 8)) {
            s = compound.func_74779_i("OwnerUUID");
        }
        if (!s.isEmpty()) {
            try {
                this.setOwnerId(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.func_184212_Q().func_187227_b(tame, (Object)compound.func_74767_n("tame"));
        this.func_184212_Q().func_187217_b(tame);
        this.func_184212_Q().func_187227_b(variant, (Object)compound.func_74762_e("variant"));
        this.func_184212_Q().func_187217_b(variant);
        this.func_184212_Q().func_187227_b(spawnPosition, (Object)new BlockPos(compound.func_74762_e("spawnX"), compound.func_74762_e("spawnY"), compound.func_74762_e("spawnZ")));
        this.func_184212_Q().func_187217_b(spawnPosition);
        this.func_184212_Q().func_187227_b(targetPosition, (Object)new BlockPos(compound.func_74762_e("targetX"), compound.func_74762_e("targetY"), compound.func_74762_e("targetZ")));
        this.func_184212_Q().func_187217_b(targetPosition);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.getOwnerId() == null) {
            compound.func_74778_a("OwnerUUID", "");
        } else {
            compound.func_74778_a("OwnerUUID", this.getOwnerId().toString());
        }
        compound.func_74757_a("tame", ((Boolean)this.func_184212_Q().func_187225_a(tame)).booleanValue());
        compound.func_74768_a("variant", ((Integer)this.func_184212_Q().func_187225_a(variant)).intValue());
        compound.func_74768_a("spawnX", ((BlockPos)this.func_184212_Q().func_187225_a(spawnPosition)).func_177958_n());
        compound.func_74768_a("spawnY", ((BlockPos)this.func_184212_Q().func_187225_a(spawnPosition)).func_177956_o());
        compound.func_74768_a("spawnZ", ((BlockPos)this.func_184212_Q().func_187225_a(spawnPosition)).func_177952_p());
        compound.func_74768_a("targetX", ((BlockPos)this.func_184212_Q().func_187225_a(targetPosition)).func_177958_n());
        compound.func_74768_a("targetY", ((BlockPos)this.func_184212_Q().func_187225_a(targetPosition)).func_177956_o());
        compound.func_74768_a("targetZ", ((BlockPos)this.func_184212_Q().func_187225_a(targetPosition)).func_177952_p());
    }

    public static enum VariantColors {
        GREEN,
        PURPLE,
        PINK,
        ORANGE,
        BLUE,
        YELLOW,
        RED;


        public String nameLower() {
            return this.name().toLowerCase();
        }

        public int red() {
            switch (this) {
                case GREEN: {
                    return 177;
                }
                case PURPLE: {
                    return 219;
                }
                case PINK: {
                    return 255;
                }
                case ORANGE: {
                    return 255;
                }
                case BLUE: {
                    return 163;
                }
                case YELLOW: {
                    return 255;
                }
                case RED: {
                    return 255;
                }
            }
            return 0;
        }

        public int green() {
            switch (this) {
                case GREEN: {
                    return 255;
                }
                case PURPLE: {
                    return 179;
                }
                case PINK: {
                    return 163;
                }
                case ORANGE: {
                    return 223;
                }
                case BLUE: {
                    return 221;
                }
                case YELLOW: {
                    return 242;
                }
                case RED: {
                    return 98;
                }
            }
            return 0;
        }

        public int blue() {
            switch (this) {
                case GREEN: {
                    return 117;
                }
                case PURPLE: {
                    return 255;
                }
                case PINK: {
                    return 255;
                }
                case ORANGE: {
                    return 163;
                }
                case BLUE: {
                    return 255;
                }
                case YELLOW: {
                    return 179;
                }
                case RED: {
                    return 114;
                }
            }
            return 0;
        }
    }
}

