/*
 * Decompiled with CFR 0.152.
 */
package teamroots.emberroot.entity.ai;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityAIFollow
extends EntityAIBase {
    private EntityLivingBase target;
    private EntityLiving entity;
    World world;
    private final double followSpeed;
    private final PathNavigate pathfinder;
    private int timeToRecalcPath;
    float maxDist;
    float minDist;
    private float oldWaterCost;

    public EntityAIFollow(EntityLiving entity, EntityLivingBase target, double followSpeedIn, float minDistIn, float maxDistIn) {
        this.entity = entity;
        this.world = entity.field_70170_p;
        this.followSpeed = followSpeedIn;
        this.pathfinder = entity.func_70661_as();
        this.minDist = minDistIn;
        this.maxDist = maxDistIn;
        this.func_75248_a(7);
        if (!(entity.func_70661_as() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        if (this.entity != null && this.target != null) {
            return !(this.entity.func_70068_e((Entity)this.target) < (double)(this.minDist * this.minDist));
        }
        return false;
    }

    public boolean continueExecuting() {
        return !this.pathfinder.func_75500_f() && this.entity.func_70068_e((Entity)this.target) > (double)(this.maxDist * this.maxDist);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.func_184643_a(PathNodeType.WATER);
        this.entity.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.target = null;
        this.pathfinder.func_75499_g();
        this.entity.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    private boolean isEmptyBlock(BlockPos pos) {
        IBlockState iblockstate = this.world.func_180495_p(pos);
        return iblockstate.func_185904_a() == Material.field_151579_a ? true : !iblockstate.func_185917_h();
    }

    public void func_75246_d() {
        this.entity.func_70606_j(0.0f);
        this.entity.func_70671_ap().func_75651_a((Entity)this.target, 10.0f, (float)this.entity.func_70646_bf());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.pathfinder.func_75497_a((Entity)this.target, this.followSpeed) && !this.entity.func_110167_bD() && this.entity.func_70068_e((Entity)this.target) >= 144.0) {
                int i = MathHelper.func_76128_c((double)this.target.field_70165_t) - 2;
                int j = MathHelper.func_76128_c((double)this.target.field_70161_v) - 2;
                int k = MathHelper.func_76128_c((double)this.target.func_174813_aQ().field_72338_b);
                for (int l = 0; l <= 4; ++l) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.world.func_180495_p(new BlockPos(i + l, k - 1, j + i1)).func_185917_h() || !this.isEmptyBlock(new BlockPos(i + l, k, j + i1)) || !this.isEmptyBlock(new BlockPos(i + l, k + 1, j + i1))) continue;
                        this.entity.func_70012_b((double)((float)(i + l) + 0.5f), (double)k, (double)((float)(j + i1) + 0.5f), this.entity.field_70177_z, this.entity.field_70125_A);
                        this.pathfinder.func_75499_g();
                        return;
                    }
                }
            }
        }
    }
}

