/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mercurius.utils;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import net.minecraftforge.mercurius.utils.LogHelper;

public class LauncherCachingHack {
    private static final int MAX_AGE = 86400000;

    public static void cullChecksum() {
        try {
            File dir = LauncherCachingHack.getJar();
            File sha = new File(dir.getAbsolutePath() + ".sha");
            if (sha.exists() && sha.isFile() && sha.lastModified() < System.currentTimeMillis() - 86400000L) {
                sha.delete();
            }
        }
        catch (Exception e) {
            LogHelper.error("[Mercurius] Could not find/delete checksum file. Mercurius may not update!");
            e.printStackTrace();
        }
    }

    private static File getJar() throws Exception {
        String suffix;
        URL url = LauncherCachingHack.class.getProtectionDomain().getCodeSource().getLocation();
        String extURL = url.toExternalForm();
        if (!extURL.endsWith(".jar") && (extURL = extURL.replace(suffix = "/" + LauncherCachingHack.class.getName().replace(".", "/") + ".class", "")).startsWith("jar:") && extURL.endsWith(".jar!")) {
            extURL = extURL.substring(4, extURL.length() - 1);
        }
        try {
            return new File(new URL(extURL).toURI());
        }
        catch (URISyntaxException ex) {
            return new File(new URL(extURL).getPath());
        }
    }
}

