/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.standalone.commands;

import aroma1997.backup.common.compression.BackupHelper;
import aroma1997.backup.common.info.BackupInfoUtil;
import aroma1997.backup.common.info.ExistingBackupInfo;
import aroma1997.backup.common.util.IOHelper;
import aroma1997.backup.standalone.command.Command;
import aroma1997.backup.standalone.command.CommandException;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;

public class CommandRestoreBackup
extends Command {
    public CommandRestoreBackup() {
        super("restoreBackup", "restore");
    }

    @Override
    public String getDescr() {
        return this.getName() + " <source backup> <target dir>";
    }

    @Override
    public void execute(String[] args) throws CommandException {
        File target;
        if (args.length != 2) {
            throw new CommandException("Invalid amount of arguments.");
        }
        File source = new File(args[0]);
        try {
            if (!BackupInfoUtil.isBackup(source)) {
                throw new IllegalArgumentException("An invalid backup was specified.");
            }
        }
        catch (IOException e1) {
            IOHelper.printError("Could not check, if backup is valid. Aborting...");
            return;
        }
        File copyto = target = new File(args[1]);
        while (copyto.exists()) {
            copyto = new File(copyto.getAbsolutePath() + "_old");
        }
        try {
            if (target != copyto) {
                Files.move(target.toPath(), copyto.toPath(), new CopyOption[0]);
            }
            ExistingBackupInfo info = new ExistingBackupInfo(source);
            BackupHelper.restoreBackup(info, target);
        }
        catch (IOException e) {
            IOHelper.printError("Failed to unpack backup.");
            e.printStackTrace();
        }
    }
}

