/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.lib;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.IStringSerializable;
import pokefenn.totemic.init.ModBlocks;

public enum WoodVariant implements IStringSerializable
{
    OAK(BlockPlanks.EnumType.OAK.func_181070_c()),
    SPRUCE(BlockPlanks.EnumType.SPRUCE.func_181070_c()),
    BIRCH(BlockPlanks.EnumType.BIRCH.func_181070_c()),
    JUNGLE(BlockPlanks.EnumType.JUNGLE.func_181070_c()),
    ACACIA(BlockPlanks.EnumType.ACACIA.func_181070_c()),
    DARK_OAK(BlockPlanks.EnumType.DARK_OAK.func_181070_c()),
    CEDAR(MapColor.field_151671_v);

    private final String name = this.toString().toLowerCase(Locale.ROOT);
    private final MapColor mapColor;

    private WoodVariant(MapColor mapColor) {
        this.mapColor = mapColor;
    }

    @Nullable
    public static WoodVariant fromLog(IBlockState log) {
        Block block = log.func_177230_c();
        int meta = block.func_176201_c(log);
        if (block == Blocks.field_150364_r) {
            return WoodVariant.values()[meta & 3];
        }
        if (block == Blocks.field_150363_s) {
            return WoodVariant.values()[4 + (meta & 3)];
        }
        if (block == ModBlocks.cedar_log) {
            return CEDAR;
        }
        return null;
    }

    public static WoodVariant fromID(int id) {
        if (id < 0 || id >= WoodVariant.values().length) {
            id = 0;
        }
        return WoodVariant.values()[id];
    }

    public int getID() {
        return this.ordinal();
    }

    public String func_176610_l() {
        return this.name;
    }

    public MapColor getMapColor() {
        return this.mapColor;
    }
}

