/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.ceremony;

import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import pokefenn.totemic.api.TotemicEntityUtil;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.entity.animal.EntityBuffalo;
import pokefenn.totemic.util.EntityUtil;

public class CeremonyBuffaloDance
extends Ceremony {
    public CeremonyBuffaloDance(String name, int musicNeeded, int maxStartupTime, MusicInstrument ... instruments) {
        super(name, musicNeeded, maxStartupTime, instruments);
    }

    @Override
    public void effect(World world, BlockPos pos, CeremonyEffectContext context) {
        if (world.field_72995_K) {
            return;
        }
        CeremonyBuffaloDance.getCows(world, pos, 8).limit(2L).forEach(cow -> {
            EntityBuffalo buffalo = new EntityBuffalo(world);
            float health = cow.func_110143_aJ() / cow.func_110138_aP() * buffalo.func_110138_aP();
            buffalo.func_70606_j(health);
            buffalo.func_70873_a(-24000);
            EntityUtil.spawnEntity(world, cow.field_70165_t, cow.field_70163_u, cow.field_70161_v, (Entity)buffalo);
            if (cow.func_110167_bD()) {
                buffalo.func_110162_b(cow.func_110166_bE(), true);
            }
            cow.func_70106_y();
            ((WorldServer)world).func_175739_a(EnumParticleTypes.VILLAGER_HAPPY, cow.field_70165_t, cow.field_70163_u + 1.0, cow.field_70161_v, 24, 0.6, 0.5, 0.6, 1.0, new int[0]);
        });
    }

    private static Stream<? extends EntityAnimal> getCows(World world, BlockPos pos, int range) {
        return TotemicEntityUtil.getEntitiesInRange(EntityCow.class, world, pos, range, range, entity -> !(entity instanceof EntityBuffalo));
    }
}

