/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pokefenn.totemic.block.totem.BlockTotemBase;
import pokefenn.totemic.lib.WoodVariant;
import pokefenn.totemic.tileentity.TileDecoPillar;

public class BlockDecoPillar
extends BlockRotatedPillar
implements ITileEntityProvider {
    public static final PropertyEnum<WoodVariant> WOOD = BlockTotemBase.WOOD;
    public static final PropertyBool STRIPPED = PropertyBool.func_177716_a((String)"stripped");
    private static final AxisAlignedBB X_BB = new AxisAlignedBB(0.0, 0.1875, 0.1875, 1.0, 0.8125, 0.8125);
    private static final AxisAlignedBB Y_BB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);
    private static final AxisAlignedBB Z_BB = new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 1.0);

    public BlockDecoPillar() {
        super(Material.field_151575_d);
        this.setRegistryName("wooden_pillar");
        this.func_149663_c("totemic:wooden_pillar");
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 5);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176298_M, (Comparable)EnumFacing.Axis.Y).func_177226_a(WOOD, (Comparable)((Object)WoodVariant.OAK)).func_177226_a((IProperty)STRIPPED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileDecoPillar tile = (TileDecoPillar)world.func_175625_s(pos);
        tile.setFromMetadata(stack.func_77960_j());
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileDecoPillar) {
            drops.add((Object)new ItemStack((Block)this, 1, ((TileDecoPillar)tile).getDropMetadata()));
        } else {
            drops.add((Object)new ItemStack((Block)this));
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileDecoPillar tile = (TileDecoPillar)world.func_175625_s(pos);
        return new ItemStack((Block)this, 1, tile.getDropMetadata());
    }

    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(I18n.func_135052_a((String)"tile.totemic:wooden_pillar.tooltip", (Object[])new Object[0]));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        int i;
        for (i = 0; i < WoodVariant.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, 2 * i));
        }
        for (i = 0; i < WoodVariant.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, 2 * i + 1));
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing.Axis)state.func_177229_b((IProperty)field_176298_M)) {
            case X: {
                return X_BB;
            }
            default: {
                return Y_BB;
            }
            case Z: 
        }
        return Z_BB;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileDecoPillar) {
            TileDecoPillar tile = (TileDecoPillar)te;
            if (tile.isStripped() || state.func_177229_b((IProperty)field_176298_M) == EnumFacing.Axis.Y) {
                return tile.getWoodType().getMapColor();
            }
            return BlockDecoPillar.getBarkColor(tile.getWoodType());
        }
        return MapColor.field_151663_o;
    }

    static MapColor getBarkColor(WoodVariant wood) {
        switch (wood) {
            default: {
                return BlockPlanks.EnumType.SPRUCE.func_181070_c();
            }
            case SPRUCE: {
                return BlockPlanks.EnumType.DARK_OAK.func_181070_c();
            }
            case BIRCH: {
                return MapColor.field_151677_p;
            }
            case JUNGLE: {
                return BlockPlanks.EnumType.SPRUCE.func_181070_c();
            }
            case ACACIA: {
                return MapColor.field_151665_m;
            }
            case DARK_OAK: {
                return BlockPlanks.EnumType.DARK_OAK.func_181070_c();
            }
            case CEDAR: 
        }
        return MapColor.field_151676_q;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176298_M, WOOD, STRIPPED});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileDecoPillar) {
            TileDecoPillar tdp = (TileDecoPillar)tile;
            return state.func_177226_a(WOOD, (Comparable)((Object)tdp.getWoodType())).func_177226_a((IProperty)STRIPPED, (Comparable)Boolean.valueOf(tdp.isStripped()));
        }
        return state;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face.func_176740_k() == state.func_177229_b((IProperty)field_176298_M)) {
            return BlockFaceShape.CENTER_BIG;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177229_b((IProperty)field_176298_M) == EnumFacing.Axis.Y;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        TileDecoPillar tile = new TileDecoPillar();
        tile.setWoodType((WoodVariant)((Object)state.func_177229_b(WOOD)));
        tile.setStripped((Boolean)state.func_177229_b((IProperty)STRIPPED));
        return tile;
    }

    @Nullable
    public TileEntity func_149915_a(World world, int meta) {
        return new TileDecoPillar();
    }
}

