/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.api.music;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import org.apache.logging.log4j.LogManager;
import pokefenn.totemic.api.TotemicRegistries;
import pokefenn.totemic.api.music.MusicAcceptor;
import pokefenn.totemic.api.music.MusicInstrument;

public class DefaultMusicAcceptor
implements MusicAcceptor {
    private final Object2IntMap<MusicInstrument> music = new Object2IntOpenHashMap(TotemicRegistries.instruments().getEntries().size());
    private int totalMusic = 0;

    @Override
    public boolean acceptMusic(MusicInstrument instr, int amount, double x, double y, double z, @Nullable Entity entity) {
        int oldVal = this.music.getInt((Object)instr);
        int newVal = Math.min(oldVal + amount, instr.getMusicMaximum());
        if (newVal != oldVal) {
            this.music.put((Object)instr, newVal);
            this.totalMusic += newVal - oldVal;
            return true;
        }
        return false;
    }

    public int getMusicAmount(MusicInstrument instr) {
        return this.music.getInt((Object)instr);
    }

    public void setMusicAmount(MusicInstrument instr, int amount) {
        int oldVal = this.music.getInt((Object)instr);
        if (amount != oldVal) {
            this.music.put((Object)instr, amount);
            this.totalMusic += amount - oldVal;
        }
    }

    public int getTotalMusic() {
        return this.totalMusic;
    }

    public static class Storage
    implements Capability.IStorage<MusicAcceptor> {
        @Nullable
        public NBTBase writeNBT(Capability<MusicAcceptor> capability, MusicAcceptor instance, EnumFacing side) {
            if (!(instance instanceof DefaultMusicAcceptor)) {
                throw new IllegalArgumentException("Can only write instances of DefaultMusicAcceptor");
            }
            DefaultMusicAcceptor acceptor = (DefaultMusicAcceptor)instance;
            NBTTagCompound nbt = new NBTTagCompound();
            for (Object2IntMap.Entry entry : acceptor.music.object2IntEntrySet()) {
                nbt.func_74768_a(((MusicInstrument)((Object)entry.getKey())).getRegistryName().toString(), entry.getIntValue());
            }
            return nbt;
        }

        public void readNBT(Capability<MusicAcceptor> capability, MusicAcceptor instance, EnumFacing side, NBTBase nbt) {
            if (!(instance instanceof DefaultMusicAcceptor)) {
                throw new IllegalArgumentException("Can only read instances of DefaultMusicAcceptor");
            }
            DefaultMusicAcceptor acceptor = (DefaultMusicAcceptor)instance;
            NBTTagCompound tag = (NBTTagCompound)nbt;
            acceptor.music.clear();
            acceptor.totalMusic = 0;
            for (String key : tag.func_150296_c()) {
                MusicInstrument instr = (MusicInstrument)TotemicRegistries.instruments().getValue(new ResourceLocation(key));
                if (instr != null) {
                    int amount = tag.func_74762_e(key);
                    acceptor.music.put((Object)instr, amount);
                    DefaultMusicAcceptor defaultMusicAcceptor = acceptor;
                    defaultMusicAcceptor.totalMusic = defaultMusicAcceptor.totalMusic + amount;
                    continue;
                }
                LogManager.getLogger(Storage.class).warn("Unknown music instrument: {}", (Object)key);
            }
        }
    }
}

