/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.api.lexicon;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import pokefenn.totemic.api.lexicon.IRecipeKeyProvider;
import pokefenn.totemic.api.lexicon.LexiconEntry;

public final class LexiconRecipeMappings {
    private static final Map<String, EntryData> mappings = new HashMap<String, EntryData>();

    public static void map(ItemStack stack, LexiconEntry entry, int page) {
        LexiconRecipeMappings.map(stack, entry, page, false);
    }

    public static void map(ItemStack stack, LexiconEntry entry, int page, boolean force) {
        String str = LexiconRecipeMappings.stackToString(stack);
        if (force || !mappings.containsKey(str)) {
            mappings.put(str, new EntryData(entry, page));
        }
    }

    public static EntryData getDataForStack(ItemStack stack) {
        return mappings.get(LexiconRecipeMappings.stackToString(stack));
    }

    private static String stackToString(ItemStack stack) {
        if (stack.func_77973_b() instanceof IRecipeKeyProvider) {
            return ((IRecipeKeyProvider)stack.func_77973_b()).getKey(stack);
        }
        return stack.func_77973_b().getRegistryName() + "@" + stack.func_77952_i();
    }

    public static class EntryData {
        public final LexiconEntry entry;
        public final int page;

        public EntryData(LexiconEntry entry, int page) {
            this.entry = entry;
            this.page = page;
        }
    }
}

