/*
 * Decompiled with CFR 0.152.
 */
package sev_tweaks_npc;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModSounds {
    public static final List<SoundEvent> SOUNDS = new ArrayList<SoundEvent>();
    public static final SoundEvent LADDER_PLACEMENT = ModSounds.registerSoundResource("ladder_placement");
    public static final SoundEvent GLEN_BARF_1 = ModSounds.registerSoundResource("glen_barf_1");
    public static final SoundEvent GLEN_WHINGE = ModSounds.registerSoundResource("glen_whinge");
    public static final SoundEvent GLEN_HURT = ModSounds.registerSoundResource("glen_hurt");
    public static final SoundEvent GLEN_DEATH = ModSounds.registerSoundResource("glen_death");

    public static SoundEvent registerSoundResource(String name) {
        return new SoundEvent(new ResourceLocation("sev_tweaks_npc", name));
    }

    public static void init() {
        try {
            for (Field field : ModSounds.class.getDeclaredFields()) {
                Object obj = field.get(null);
                if (!(obj instanceof SoundEvent)) continue;
                SoundEvent sound = (SoundEvent)obj;
                String name = field.getName().toLowerCase(Locale.ENGLISH);
                ModSounds.registerSoundName(name, sound);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerSoundName(String name, SoundEvent sound) {
        SOUNDS.add(sound);
        sound.setRegistryName("sev_tweaks_npc", name);
    }

    @Mod.EventBusSubscriber(modid="sev_tweaks_npc")
    public static class RegistrationHandlerSounds {
        @SubscribeEvent
        public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
            ModSounds.init();
            IForgeRegistry registry = event.getRegistry();
            for (SoundEvent sounds : SOUNDS) {
                registry.register((IForgeRegistryEntry)sounds);
            }
        }
    }
}

