/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.addons.core.HUDHandlerEntities;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.impl.ConfigModule;
import mcp.mobius.waila.api.impl.MetaDataProvider;
import mcp.mobius.waila.config.FormattingConfig;
import mcp.mobius.waila.config.OverlayConfig;
import mcp.mobius.waila.utils.Constants;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class ConfigHandler
implements IWailaConfigHandler {
    private static ConfigHandler _instance = null;
    public Map<String, Boolean> forcedConfigs = new HashMap<String, Boolean>();
    public Configuration config = null;
    private LinkedHashMap<String, ConfigModule> modules = new LinkedHashMap();
    private ArrayList<String> serverconfigs = new ArrayList();

    private ConfigHandler() {
        _instance = this;
    }

    public void addModule(String modName, HashMap<String, String> options) {
        this.addModule(modName, new ConfigModule(modName, options));
    }

    public void addModule(String modName, ConfigModule options) {
        this.modules.put(modName, options);
    }

    @Override
    public Set<String> getModuleNames() {
        return this.modules.keySet();
    }

    @Override
    public HashMap<String, String> getConfigKeys(String modName) {
        if (this.modules.containsKey(modName)) {
            return this.modules.get((Object)modName).options;
        }
        return null;
    }

    private void saveModuleKey(String modName, String key) {
        this.saveModuleKey(modName, key, Constants.CFG_DEFAULT_VALUE);
    }

    private void saveModuleKey(String modName, String key, boolean defvalue) {
        this.config.get("modules", key, defvalue);
        this.config.get("server_forcing", key, false);
        this.config.save();
    }

    public void addConfig(String modName, String key, String name) {
        this.addConfig(modName, key, name, Constants.CFG_DEFAULT_VALUE);
    }

    public void addConfig(String modName, String key, String name, boolean defvalue) {
        this.saveModuleKey(modName, key, defvalue);
        if (!this.modules.containsKey(modName)) {
            this.modules.put(modName, new ConfigModule(modName));
        }
        this.modules.get(modName).addOption(key, name);
    }

    public void addConfigServer(String modName, String key, String name) {
        this.addConfigServer(modName, key, name, Constants.CFG_DEFAULT_VALUE);
    }

    public void addConfigServer(String modName, String key, String name, boolean defvalue) {
        this.saveModuleKey(modName, key, defvalue);
        if (!this.modules.containsKey(modName)) {
            this.modules.put(modName, new ConfigModule(modName));
        }
        this.modules.get(modName).addOption(key, name);
        this.serverconfigs.add(key);
    }

    @Override
    public boolean getConfig(String key) {
        return this.getConfig(key, Constants.CFG_DEFAULT_VALUE);
    }

    @Override
    public boolean getConfig(String key, boolean defvalue) {
        if (this.serverconfigs.contains(key) && !Waila.instance.serverPresent) {
            return false;
        }
        if (this.forcedConfigs.containsKey(key)) {
            return this.forcedConfigs.get(key);
        }
        Property prop = this.config.get("modules", key, defvalue);
        return prop.getBoolean(defvalue);
    }

    public boolean isServerRequired(String key) {
        return this.serverconfigs.contains(key);
    }

    public boolean getConfig(String category, String key, boolean default_) {
        Property prop = this.config.get(category, key, default_);
        return prop.getBoolean(default_);
    }

    public void setConfig(String category, String key, boolean state) {
        this.config.getCategory(category).put(key, new Property(key, String.valueOf(state), Property.Type.BOOLEAN));
        this.config.save();
    }

    public String getConfig(String category, String key, String default_) {
        Property prop = this.config.get(category, key, default_);
        return prop.getString();
    }

    public void setConfig(String category, String key, String value) {
        this.config.getCategory(category).put(key, new Property(key, value, Property.Type.STRING));
        this.config.save();
    }

    public int getConfig(String category, String key, int default_) {
        Property prop = this.config.get(category, key, default_);
        return prop.getInt();
    }

    public void setConfig(String category, String key, int state) {
        this.config.getCategory(category).put(key, new Property(key, String.valueOf(state), Property.Type.INTEGER));
        this.config.save();
    }

    public boolean showTooltip() {
        return this.getConfig("general", "waila.cfg.show", true);
    }

    public boolean hideFromList() {
        return this.getConfig("general", "waila.cfg.hidefromlist", true);
    }

    public boolean hideFromDebug() {
        return this.getConfig("general", "waila.cfg.hidefromdebug", true);
    }

    public boolean showItem() {
        return this.getConfig("general", "waila.cfg.showitem", true);
    }

    public void loadDefaultConfig(FMLPreInitializationEvent event) {
        File configFile = new File(Waila.configDir, "waila.cfg");
        try {
            FileUtils.forceMkdir((File)Waila.configDir);
            File file = event.getSuggestedConfigurationFile();
            if (file.exists() && !configFile.exists()) {
                FileUtils.moveFile((File)file, (File)configFile);
            }
        }
        catch (Exception e) {
            Waila.LOGGER.error("Error migrating config to new location");
        }
        this.config = new Configuration(configFile);
        this.config.get("general", "waila.cfg.show", true);
        this.config.get("general", "waila.cfg.showmode", true);
        this.config.get("general", "waila.cfg.liquid", false);
        this.config.get("general", "waila.cfg.metadata", false);
        this.config.get("general", "waila.cfg.keybind", true);
        this.config.get("general", "waila.cfg.newfilters", true);
        this.config.get("general", "waila.cfg.hidefromlist", true);
        this.config.get("general", "waila.cfg.hidefromdebug", false);
        this.config.get("general", "waila.cfg.showitem", true);
        this.config.get("general", "waila.cfg.tts", false);
        OverlayConfig.posX = this.config.get("general", "waila.cfg.posx", 5000).getInt();
        OverlayConfig.posY = this.config.get("general", "waila.cfg.posy", 100).getInt();
        OverlayConfig.scale = (float)this.config.get("general", "waila.cfg.scale", 100).getInt() / 100.0f;
        OverlayConfig.updateColors();
        FormattingConfig.modNameFormat = StringEscapeUtils.unescapeJava((String)this.config.get("general", "waila.cfg.modnameformat", StringEscapeUtils.escapeJava((String)"\u00a79\u00a7o%s")).getString());
        FormattingConfig.blockFormat = StringEscapeUtils.unescapeJava((String)this.config.get("general", "waila.cfg.blocknameformat", StringEscapeUtils.escapeJava((String)"\u00a7f%s")).getString());
        FormattingConfig.fluidFormat = StringEscapeUtils.unescapeJava((String)this.config.get("general", "waila.cfg.fluidnameformat", StringEscapeUtils.escapeJava((String)"\u00a7f%s")).getString());
        FormattingConfig.entityFormat = StringEscapeUtils.unescapeJava((String)this.config.get("general", "waila.cfg.entitynameformat", StringEscapeUtils.escapeJava((String)"\u00a7f%s")).getString());
        FormattingConfig.metaFormat = StringEscapeUtils.unescapeJava((String)this.config.get("general", "waila.cfg.metadataformat", StringEscapeUtils.escapeJava((String)"\u00a77[%s@%d]")).getString());
        HUDHandlerEntities.nhearts = this.config.get("general", "waila.cfg.heartsperline", 20).getInt();
        HUDHandlerEntities.maxhpfortext = this.config.get("general", "waila.cfg.maxhpbeforetext", 40).getInt();
        Property rateLimiterProp = this.config.get("client", "waila.cfg.ratelimiter", 250);
        rateLimiterProp.setMinValue(250);
        rateLimiterProp.setComment("The amount of time in milliseconds (1000ms = 1s) between queries to the server for Tile Entity and Entity data. There is an enforced minimum of 250 (or every 1/4 of a second).");
        MetaDataProvider.rateLimiter = rateLimiterProp.getInt();
        if (MetaDataProvider.rateLimiter < 250) {
            MetaDataProvider.rateLimiter = 250;
        }
        this.config.getCategory("modules").setComment("Those are the config keys defined in modules.\nServer side, it is used to enforce keys client side using the next section.");
        this.config.getCategory("server_forcing").setComment("Any key set to true here will ensure that the client is using the configuration set in the 'module' section above.\nThis is useful for enforcing false to 'cheating' keys like silverfish.");
        this.config.save();
    }

    public static ConfigHandler instance() {
        return _instance == null ? new ConfigHandler() : _instance;
    }
}

