/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila;

import java.io.File;
import java.util.Set;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import mcp.mobius.waila.commands.CommandDumpHandlers;
import mcp.mobius.waila.network.MessageReceiveData;
import mcp.mobius.waila.network.MessageRequestEntity;
import mcp.mobius.waila.network.MessageRequestTile;
import mcp.mobius.waila.network.MessageServerPing;
import mcp.mobius.waila.proxy.IProxy;
import net.minecraft.command.ICommand;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="waila", name="Waila", version="1.8.26", dependencies="", acceptableRemoteVersions="*", guiFactory="mcp.mobius.waila.gui.ConfigGuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class Waila {
    public static final String MODID = "waila";
    public static final String NAME = "Waila";
    public static final String VERSION = "1.8.26";
    public static final String DEPEND = "";
    public static final Logger LOGGER = LogManager.getLogger((String)"Waila");
    public static final SimpleNetworkWrapper NETWORK_WRAPPER = new SimpleNetworkWrapper("waila");
    @Mod.Instance(value="waila")
    public static Waila instance;
    @SidedProxy(clientSide="mcp.mobius.waila.proxy.ProxyClient", serverSide="mcp.mobius.waila.proxy.ProxyServer")
    public static IProxy proxy;
    public static Set<ASMDataTable.ASMData> plugins;
    public static File configDir;
    public static File themeDir;
    public boolean serverPresent = false;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        NETWORK_WRAPPER.registerMessage(MessageServerPing.Handler.class, MessageServerPing.class, 0, Side.CLIENT);
        NETWORK_WRAPPER.registerMessage(MessageRequestTile.Handler.class, MessageRequestTile.class, 1, Side.SERVER);
        NETWORK_WRAPPER.registerMessage(MessageRequestEntity.Handler.class, MessageRequestEntity.class, 2, Side.SERVER);
        NETWORK_WRAPPER.registerMessage(MessageReceiveData.Handler.class, MessageReceiveData.class, 3, Side.CLIENT);
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        proxy.loadComplete(event);
    }

    @Mod.EventHandler
    public void processIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage imcMessage : event.getMessages()) {
            if (!imcMessage.isStringMessage()) continue;
            if (imcMessage.key.equalsIgnoreCase("addconfig")) {
                String[] params = imcMessage.getStringValue().split("\\$\\$");
                if (params.length != 3) {
                    LOGGER.warn("Error while parsing config option from [ {} ] for {}", (Object)imcMessage.getSender(), (Object)imcMessage.getStringValue());
                    continue;
                }
                LOGGER.debug("Receiving config request from [ {} ] for {}", (Object)imcMessage.getSender(), (Object)imcMessage.getStringValue());
                ConfigHandler.instance().addConfig(params[0], params[1], params[2]);
            }
            if (!imcMessage.key.equalsIgnoreCase("register")) continue;
            LOGGER.debug("Receiving registration request from [ {} ] for method {}", (Object)imcMessage.getSender(), (Object)imcMessage.getStringValue());
            ModuleRegistrar.instance().addIMCRequest(imcMessage.getStringValue(), imcMessage.getSender());
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandDumpHandlers());
    }
}

