/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.config.FuzzyMode;
import com.google.common.base.Preconditions;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

final class AESharedItemStack
implements Comparable<AESharedItemStack> {
    private static final NBTTagCompound LOW_TAG = new NBTTagCompound();
    private static final NBTTagCompound HIGH_TAG = new NBTTagCompound();
    private final ItemStack itemStack;
    private final int itemId;
    private final int itemDamage;

    public AESharedItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.itemId = Item.func_150891_b((Item)itemStack.func_77973_b());
        this.itemDamage = itemStack.func_77952_i();
    }

    Bounds getBounds(FuzzyMode fuzzy, boolean ignoreMeta) {
        return new Bounds(this.itemStack, fuzzy, ignoreMeta);
    }

    ItemStack getDefinition() {
        return this.itemStack;
    }

    int getItemDamage() {
        return this.itemDamage;
    }

    int getItemID() {
        return this.itemId;
    }

    public int hashCode() {
        return Objects.hash(this.itemId, this.itemDamage, this.itemStack.func_77942_o() ? this.itemStack.func_77978_p() : Integer.valueOf(0));
    }

    public boolean equals(Object obj) {
        if (obj instanceof AESharedItemStack) {
            AESharedItemStack other = (AESharedItemStack)obj;
            Preconditions.checkState((this.itemStack.func_190916_E() == 1 ? 1 : 0) != 0, (Object)"ItemStack#getCount() has to be 1");
            Preconditions.checkArgument((other.getDefinition().func_190916_E() == 1 ? 1 : 0) != 0, (Object)"ItemStack#getCount() has to be 1");
            if (this.itemStack == other.itemStack) {
                return true;
            }
            return ItemStack.func_77989_b((ItemStack)this.itemStack, (ItemStack)other.itemStack);
        }
        return false;
    }

    @Override
    public int compareTo(AESharedItemStack b) {
        Preconditions.checkState((this.itemStack.func_190916_E() == 1 ? 1 : 0) != 0, (Object)"ItemStack#getCount() has to be 1");
        Preconditions.checkArgument((b.getDefinition().func_190916_E() == 1 ? 1 : 0) != 0, (Object)"ItemStack#getCount() has to be 1");
        if (this.itemStack == b.getDefinition()) {
            return 0;
        }
        int id = this.itemId - b.itemId;
        if (id != 0) {
            return id;
        }
        int damageValue = this.itemDamage - b.itemDamage;
        if (damageValue != 0) {
            return damageValue;
        }
        int nbt = this.compareNBT(b.getDefinition());
        if (nbt != 0) {
            return nbt;
        }
        if (!this.itemStack.areCapsCompatible(b.getDefinition())) {
            return System.identityHashCode(this.itemStack) - System.identityHashCode(b.getDefinition());
        }
        return 0;
    }

    private int compareNBT(ItemStack b) {
        if (this.itemStack.func_77978_p() == b.func_77978_p()) {
            return 0;
        }
        if (this.itemStack.func_77978_p() == LOW_TAG || b.func_77978_p() == HIGH_TAG) {
            return -1;
        }
        if (this.itemStack.func_77978_p() == HIGH_TAG || b.func_77978_p() == LOW_TAG) {
            return 1;
        }
        return System.identityHashCode(this.itemStack.func_77978_p()) - System.identityHashCode(b.func_77978_p());
    }

    public static final class Bounds {
        private static final int MIN_DAMAGE_VALUE = 0;
        private static final int MAX_DAMAGE_VALUE = 65535;
        private final AESharedItemStack lower;
        private final AESharedItemStack upper;

        public Bounds(ItemStack stack, FuzzyMode fuzzy, boolean ignoreMeta) {
            Preconditions.checkState((!stack.func_190926_b() ? 1 : 0) != 0, (Object)"ItemStack#isEmpty() has to be false");
            Preconditions.checkState((stack.func_190916_E() == 1 ? 1 : 0) != 0, (Object)"ItemStack#getCount() has to be 1");
            NBTTagCompound tag = stack.func_77942_o() ? stack.func_77978_p() : null;
            this.lower = this.makeLowerBound(stack, tag, fuzzy, ignoreMeta);
            this.upper = this.makeUpperBound(stack, tag, fuzzy, ignoreMeta);
        }

        public AESharedItemStack lower() {
            return this.lower;
        }

        public AESharedItemStack upper() {
            return this.upper;
        }

        private AESharedItemStack makeLowerBound(ItemStack itemStack, NBTTagCompound tag, FuzzyMode fuzzy, boolean ignoreMeta) {
            ItemStack newDef = itemStack.func_77946_l();
            if (ignoreMeta) {
                newDef.func_77964_b(0);
                newDef.func_77982_d(tag);
            } else {
                if (newDef.func_77973_b().func_77645_m()) {
                    if (fuzzy == FuzzyMode.IGNORE_ALL) {
                        newDef.func_77964_b(0);
                    } else if (fuzzy == FuzzyMode.PERCENT_99) {
                        if (itemStack.func_77952_i() == 0) {
                            newDef.func_77964_b(0);
                        } else {
                            newDef.func_77964_b(1);
                        }
                    } else {
                        int breakpoint = fuzzy.calculateBreakPoint(itemStack.func_77958_k());
                        int damage = breakpoint <= itemStack.func_77952_i() ? breakpoint : 0;
                        newDef.func_77964_b(damage);
                    }
                }
                newDef.func_77982_d(LOW_TAG);
            }
            return new AESharedItemStack(newDef);
        }

        private AESharedItemStack makeUpperBound(ItemStack itemStack, NBTTagCompound tag, FuzzyMode fuzzy, boolean ignoreMeta) {
            ItemStack newDef = itemStack.func_77946_l();
            if (ignoreMeta) {
                newDef.func_77964_b(65535);
                newDef.func_77982_d(tag);
            } else {
                if (newDef.func_77973_b().func_77645_m()) {
                    if (fuzzy == FuzzyMode.IGNORE_ALL) {
                        newDef.func_77964_b(itemStack.func_77958_k() + 1);
                    } else if (fuzzy == FuzzyMode.PERCENT_99) {
                        if (itemStack.func_77952_i() == 0) {
                            newDef.func_77964_b(0);
                        } else {
                            newDef.func_77964_b(itemStack.func_77958_k() + 1);
                        }
                    } else {
                        int breakpoint = fuzzy.calculateBreakPoint(itemStack.func_77958_k());
                        int damage = itemStack.func_77952_i() < breakpoint ? breakpoint - 1 : itemStack.func_77958_k() + 1;
                        newDef.func_77964_b(damage);
                    }
                }
                newDef.func_77982_d(HIGH_TAG);
            }
            return new AESharedItemStack(newDef);
        }
    }
}

