/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.helpers.IPriorityHost;
import appeng.parts.automation.PartUpgradeable;
import appeng.parts.automation.PlaneConnections;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public abstract class PartAbstractFormationPlane<T extends IAEStack<T>>
extends PartUpgradeable
implements ICellContainer,
IPriorityHost,
IMEInventory<T> {
    private boolean wasActive = false;
    private int priority = 0;
    protected boolean blocked = false;

    public PartAbstractFormationPlane(ItemStack is) {
        super(is);
    }

    protected abstract void updateHandler();

    @Override
    protected int getUpgradeSlots() {
        return 5;
    }

    @Override
    public void upgradesChanged() {
        this.updateHandler();
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.updateHandler();
        this.getHost().markForSave();
    }

    public void stateChanged() {
        boolean currentActive = this.getProxy().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            this.updateHandler();
            this.getHost().markForUpdate();
        }
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        boolean minX = true;
        boolean minY = true;
        int maxX = 15;
        int maxY = 15;
        IPartHost host = this.getHost();
        if (host != null) {
            TileEntity te = host.getTile();
            BlockPos pos = te.func_174877_v();
            EnumFacing e = bch.getWorldX();
            EnumFacing u = bch.getWorldY();
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(e.func_176734_d())), this.getSide())) {
                minX = false;
            }
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(e)), this.getSide())) {
                maxX = 16;
            }
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(u.func_176734_d())), this.getSide())) {
                minY = false;
            }
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(u)), this.getSide())) {
                maxY = 16;
            }
        }
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox((double)minX, (double)minY, 15.0, maxX, maxY, 16.0);
    }

    public PlaneConnections getConnections() {
        EnumFacing facingUp;
        EnumFacing facingRight;
        AEPartLocation location = this.getSide();
        switch (location) {
            case UP: {
                facingRight = EnumFacing.EAST;
                facingUp = EnumFacing.NORTH;
                break;
            }
            case DOWN: {
                facingRight = EnumFacing.WEST;
                facingUp = EnumFacing.NORTH;
                break;
            }
            case NORTH: {
                facingRight = EnumFacing.WEST;
                facingUp = EnumFacing.UP;
                break;
            }
            case SOUTH: {
                facingRight = EnumFacing.EAST;
                facingUp = EnumFacing.UP;
                break;
            }
            case WEST: {
                facingRight = EnumFacing.SOUTH;
                facingUp = EnumFacing.UP;
                break;
            }
            case EAST: {
                facingRight = EnumFacing.NORTH;
                facingUp = EnumFacing.UP;
                break;
            }
            default: {
                return PlaneConnections.of(false, false, false, false);
            }
        }
        boolean left = false;
        boolean right = false;
        boolean down = false;
        boolean up = false;
        IPartHost host = this.getHost();
        if (host != null) {
            TileEntity te = host.getTile();
            BlockPos pos = te.func_174877_v();
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingRight.func_176734_d())), this.getSide())) {
                left = true;
            }
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingRight)), this.getSide())) {
                right = true;
            }
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingUp.func_176734_d())), this.getSide())) {
                down = true;
            }
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingUp)), this.getSide())) {
                up = true;
            }
        }
        return PlaneConnections.of(up, right, down, left);
    }

    @Override
    public void onNeighborChanged(IBlockAccess w, BlockPos pos, BlockPos neighbor) {
        if (pos.func_177972_a(this.getSide().getFacing()).equals((Object)neighbor)) {
            TileEntity te = this.getHost().getTile();
            AEPartLocation side = this.getSide();
            BlockPos tePos = te.func_174877_v().func_177972_a(side.getFacing());
            this.blocked = !w.func_180495_p(tePos).func_177230_c().func_176200_f(w, tePos);
        }
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    protected boolean isTransitionPlane(TileEntity blockTileEntity, AEPartLocation side) {
        if (blockTileEntity instanceof IPartHost) {
            IPart p = ((IPartHost)blockTileEntity).getPart(side);
            return p != null && this.getClass() == p.getClass();
        }
        return false;
    }

    @Override
    public T extractItems(T request, Actionable mode, IActionSource src) {
        return null;
    }

    @Override
    public IItemList<T> getAvailableItems(IItemList<T> out) {
        return out;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.priority = data.func_74762_e("priority");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("priority", this.getPriority());
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.getHost().markForSave();
        this.updateHandler();
    }

    @Override
    public void blinkCell(int slot) {
    }

    @Override
    public void saveChanges(ICellInventory<?> cell) {
    }
}

