/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.client.gui;

import appeng.api.config.AccessRestriction;
import appeng.api.config.ActionItems;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.client.gui.implementations.GuiUpgradeable;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketConfigButton;
import appeng.core.sync.packets.PacketSwitchGuis;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.fluids.client.gui.widgets.GuiFluidSlot;
import appeng.fluids.client.gui.widgets.GuiOptionalFluidSlot;
import appeng.fluids.container.ContainerFluidStorageBus;
import appeng.fluids.parts.PartFluidStorageBus;
import appeng.fluids.util.IAEFluidTank;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import org.lwjgl.input.Mouse;

public class GuiFluidStorageBus
extends GuiUpgradeable {
    private GuiImgButton rwMode;
    private GuiImgButton storageFilter;
    private GuiTabButton priority;
    private GuiImgButton partition;
    private GuiImgButton clear;
    private final PartFluidStorageBus bus;

    public GuiFluidStorageBus(InventoryPlayer inventoryPlayer, PartFluidStorageBus te) {
        super(new ContainerFluidStorageBus(inventoryPlayer, te));
        this.field_147000_g = 251;
        this.bus = te;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int xo = 8;
        int yo = 29;
        IAEFluidTank config = this.bus.getConfig();
        ContainerFluidStorageBus container = (ContainerFluidStorageBus)this.field_147002_h;
        for (int y = 0; y < 7; ++y) {
            for (int x = 0; x < 9; ++x) {
                int idx = y * 9 + x;
                if (y < 2) {
                    this.guiSlots.add(new GuiFluidSlot(config, idx, idx, 8 + x * 18, 29 + y * 18));
                    continue;
                }
                this.guiSlots.add(new GuiOptionalFluidSlot(config, container, idx, idx, y - 2, 8, 29, x, y));
            }
        }
    }

    @Override
    protected void addButtons() {
        this.clear = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 8, Settings.ACTIONS, ActionItems.CLOSE);
        this.partition = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 28, Settings.ACTIONS, ActionItems.WRENCH);
        this.rwMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 48, Settings.ACCESS, AccessRestriction.READ_WRITE);
        this.storageFilter = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 68, Settings.STORAGE_FILTER, StorageFilter.EXTRACTABLE_ONLY);
        this.fuzzyMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 88, Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.priority = new GuiTabButton(this.field_147003_i + 154, this.field_147009_r, 66, GuiText.Priority.getLocal(), this.field_146296_j);
        this.field_146292_n.add(this.priority);
        this.field_146292_n.add(this.storageFilter);
        this.field_146292_n.add(this.fuzzyMode);
        this.field_146292_n.add(this.rwMode);
        this.field_146292_n.add(this.partition);
        this.field_146292_n.add(this.clear);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(this.getName().getLocal()), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 8, this.field_147000_g - 96 + 3, 0x404040);
        if (this.fuzzyMode != null) {
            this.fuzzyMode.set(this.cvb.getFuzzyMode());
        }
        if (this.storageFilter != null) {
            this.storageFilter.set(((ContainerFluidStorageBus)this.cvb).getStorageFilter());
        }
        if (this.rwMode != null) {
            this.rwMode.set(((ContainerFluidStorageBus)this.cvb).getReadWriteMode());
        }
    }

    @Override
    protected String getBackground() {
        return "guis/storagebus.png";
    }

    @Override
    protected void func_146284_a(GuiButton btn) throws IOException {
        super.func_146284_a(btn);
        boolean backwards = Mouse.isButtonDown((int)1);
        try {
            if (btn == this.partition) {
                NetworkHandler.instance().sendToServer(new PacketValueConfig("StorageBus.Action", "Partition"));
            } else if (btn == this.clear) {
                NetworkHandler.instance().sendToServer(new PacketValueConfig("StorageBus.Action", "Clear"));
            } else if (btn == this.priority) {
                NetworkHandler.instance().sendToServer(new PacketSwitchGuis(GuiBridge.GUI_PRIORITY));
            } else if (btn == this.rwMode) {
                NetworkHandler.instance().sendToServer(new PacketConfigButton(this.rwMode.getSetting(), backwards));
            } else if (btn == this.storageFilter) {
                NetworkHandler.instance().sendToServer(new PacketConfigButton(this.storageFilter.getSetting(), backwards));
            }
        }
        catch (IOException e) {
            AELog.debug(e);
        }
    }

    @Override
    protected GuiText getName() {
        return GuiText.StorageBusFluids;
    }
}

