/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.spatial;

import appeng.client.render.spatial.SpatialPylonBakedModel;
import appeng.client.render.spatial.SpatialPylonTextureType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

class SpatialPylonModel
implements IModel {
    SpatialPylonModel() {
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return Arrays.stream(SpatialPylonTextureType.values()).map(SpatialPylonModel::getTexturePath).collect(Collectors.toList());
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        EnumMap<SpatialPylonTextureType, TextureAtlasSprite> textures = new EnumMap<SpatialPylonTextureType, TextureAtlasSprite>(SpatialPylonTextureType.class);
        for (SpatialPylonTextureType type : SpatialPylonTextureType.values()) {
            ResourceLocation loc = SpatialPylonModel.getTexturePath(type);
            textures.put(type, bakedTextureGetter.apply(loc));
        }
        return new SpatialPylonBakedModel(format, textures);
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    private static ResourceLocation getTexturePath(SpatialPylonTextureType type) {
        return new ResourceLocation("appliedenergistics2", "blocks/spatial_pylon/" + type.name().toLowerCase());
    }
}

