/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.storage;

import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.block.storage.DriveSlotState;

public class DriveSlotsState {
    private final DriveSlotState[] slots;

    private DriveSlotsState(DriveSlotState[] slots) {
        this.slots = slots;
    }

    public DriveSlotState getState(int index) {
        if (index >= this.slots.length) {
            return DriveSlotState.EMPTY;
        }
        return this.slots[index];
    }

    public int getSlotCount() {
        return this.slots.length;
    }

    public static DriveSlotsState fromChestOrDrive(IChestOrDrive chestOrDrive) {
        DriveSlotState[] slots = new DriveSlotState[chestOrDrive.getCellCount()];
        for (int i = 0; i < chestOrDrive.getCellCount(); ++i) {
            if (!chestOrDrive.isPowered()) {
                if (chestOrDrive.getCellStatus(i) != 0) {
                    slots[i] = DriveSlotState.OFFLINE;
                    continue;
                }
                slots[i] = DriveSlotState.EMPTY;
                continue;
            }
            slots[i] = DriveSlotState.fromCellStatus(chestOrDrive.getCellStatus(i));
        }
        return new DriveSlotsState(slots);
    }

    public static DriveSlotsState createEmpty(int slotCount) {
        DriveSlotState[] slots = new DriveSlotState[slotCount];
        for (int i = 0; i < slotCount; ++i) {
            slots[i] = DriveSlotState.EMPTY;
        }
        return new DriveSlotsState(slots);
    }
}

