/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.compat.CraftTweaker2.registries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dave.bonsaitrees.api.IBonsaiSoil;
import org.dave.bonsaitrees.api.IBonsaiTreeType;

public class TagModificationsRegistry {
    public static Map<String, List<String>> soilAdditions = new HashMap<String, List<String>>();
    public static Map<String, List<String>> soilRemovals = new HashMap<String, List<String>>();
    public static Map<String, List<String>> treeAdditions = new HashMap<String, List<String>>();
    public static Map<String, List<String>> treeRemovals = new HashMap<String, List<String>>();

    public static void addCompatibleTagToTree(String treeName, String tag) {
        if (!treeAdditions.containsKey(treeName)) {
            treeAdditions.put(treeName, new ArrayList());
        }
        treeAdditions.get(treeName).add(tag);
    }

    public static void removeCompatibleTagFromTree(String treeName, String tag) {
        if (!treeRemovals.containsKey(treeName)) {
            treeRemovals.put(treeName, new LinkedList());
        }
        treeRemovals.get(treeName).add(tag);
    }

    public static void addProvidedTagToSoil(String soilName, String tag) {
        if (!soilAdditions.containsKey(soilName)) {
            soilAdditions.put(soilName, new ArrayList());
        }
        soilAdditions.get(soilName).add(tag);
    }

    public static void removeProvidedTagFromSoil(String soilName, String tag) {
        if (!soilRemovals.containsKey(soilName)) {
            soilRemovals.put(soilName, new LinkedList());
        }
        soilRemovals.get(soilName).add(tag);
    }

    public static Set<String> getModifiedTagList(IBonsaiTreeType tree) {
        HashSet<String> result = new HashSet<String>(tree.getCompatibleSoilTags());
        if (treeAdditions.containsKey(tree.getName())) {
            result.addAll((Collection<String>)treeAdditions.get(tree.getName()));
        }
        if (treeRemovals.containsKey(tree.getName())) {
            result.removeAll((Collection)treeRemovals.get(tree.getName()));
        }
        return result;
    }

    public static Set<String> getModifiedTagList(IBonsaiSoil soil) {
        HashSet<String> result = new HashSet<String>(soil.getProvidedTags());
        if (soilAdditions.containsKey(soil.getName())) {
            result.addAll((Collection<String>)soilAdditions.get(soil.getName()));
        }
        if (soilRemovals.containsKey(soil.getName())) {
            result.removeAll((Collection)soilRemovals.get(soil.getName()));
        }
        return result;
    }
}

