/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.compat.CraftTweaker2.handlers;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import org.dave.bonsaitrees.compat.CraftTweaker2.CraftTweakerUtils;
import org.dave.bonsaitrees.compat.CraftTweaker2.registries.TreeDropModificationsRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.bonsaitrees.TreeDrops")
public class TreeDropHandler {
    @ZenMethod
    public static void addTreeDrop(String treeName, IItemStack input, float chance) {
        CraftTweakerAPI.apply((IAction)new AddTreeDrop(treeName, input, chance));
    }

    @ZenMethod
    public static void removeTreeDrop(String treeName, IItemStack input) {
        CraftTweakerAPI.apply((IAction)new RemoveTreeDrop(treeName, input));
    }

    private static class RemoveTreeDrop
    implements IAction {
        String treeName;
        IItemStack input;

        public RemoveTreeDrop(String treeName, IItemStack input) {
            this.treeName = treeName;
            this.input = input;
        }

        public void apply() {
            TreeDropModificationsRegistry.remove(this.treeName, CraftTweakerUtils.getItemStack((IIngredient)this.input));
        }

        public String describe() {
            return "Removing '" + this.input.getDisplayName() + "' drop from tree type '" + this.treeName + "'";
        }
    }

    private static class AddTreeDrop
    implements IAction {
        String treeName;
        IItemStack input;
        float chance;

        public AddTreeDrop(String treeName, IItemStack input, float chance) {
            this.treeName = treeName;
            this.input = input;
            this.chance = chance;
        }

        public void apply() {
            TreeDropModificationsRegistry.add(this.treeName, CraftTweakerUtils.getItemStack((IIngredient)this.input), this.chance);
        }

        public String describe() {
            return "Adding '" + this.input.getDisplayName() + "' drop to tree type '" + this.treeName + "'";
        }
    }
}

