/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.client.opengex.ogex;

import com.github.atomicblom.weirdinggadget.client.opengex.OpenGEXNode;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexAnimation;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexTransform;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OgexNode
implements OpenGEXNode {
    private String name;
    private final List<OgexTransform> transforms = new ArrayList<OgexTransform>();
    private final Map<Integer, OgexAnimation> animations = Maps.newHashMap();
    private final ArrayList<OgexNode> childNodes = new ArrayList();
    private int index;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addTransform(OgexTransform o) {
        this.transforms.add(o);
    }

    public List<OgexTransform> getTransforms() {
        return this.transforms;
    }

    public void addAnimation(OgexAnimation anim) {
        this.animations.put(anim.getClip(), anim);
    }

    public OgexAnimation getAnimation(int clip) {
        return this.animations.get(clip);
    }

    public Collection<OgexAnimation> getAnimations() {
        return this.animations.values();
    }

    public Set<Integer> getAnimationClips() {
        return this.animations.keySet();
    }

    public void dumpTree(String indent) {
        System.out.println(indent + this.toString());
        if (this.animations != null) {
            for (Map.Entry entry : this.animations.entrySet()) {
                System.out.println(indent + "    animation[" + entry.getKey() + "]=" + entry.getValue());
            }
        }
        for (OgexNode ogexNode : this) {
            ogexNode.dumpTree(indent + "    ");
        }
    }

    protected void appendFieldStrings(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append("name=" + this.getName() + ", transforms=" + this.transforms + ", childCount=" + this.childNodes.size());
        sb.append(", animationCount=" + (this.animations != null ? this.animations.size() : 0));
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendFieldStrings(sb);
        return this.getClass().getSimpleName() + "[" + sb + "]";
    }

    @Override
    public Iterator<OgexNode> iterator() {
        return this.childNodes.iterator();
    }

    public void add(OgexNode node) {
        this.childNodes.add(node);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

