/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.client.opengex.oddl;

import com.github.atomicblom.weirdinggadget.client.opengex.oddl.BaseStructure;
import com.github.atomicblom.weirdinggadget.client.opengex.oddl.DataStructure;
import com.github.atomicblom.weirdinggadget.client.opengex.oddl.PrimitiveType;
import java.lang.reflect.Array;

public class PrimitiveStructure
extends BaseStructure {
    private PrimitiveType type;
    private int elementCount;
    private int elementSize;
    private Object data;

    public PrimitiveStructure(PrimitiveType type, DataStructure parent, int[] location) {
        super(parent, location);
        this.type = type;
    }

    public PrimitiveType getPrimitiveType() {
        return this.type;
    }

    public int getSize() {
        return this.elementCount;
    }

    protected void setElementSize(int i) {
        this.elementSize = i;
    }

    public int getElementSize() {
        return this.elementSize;
    }

    protected void setData(Object data) {
        this.data = data;
        this.elementCount = data == null ? 0 : Array.getLength(data);
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public <T> T getValue() {
        if (this.elementCount == 0 || this.data == null) {
            return null;
        }
        if (this.elementCount > 1) {
            throw new RuntimeException("Array has more than one value");
        }
        Object value = Array.get(this.data, 0);
        return (T)value;
    }

    @Override
    public String getType() {
        if (this.elementSize > 0) {
            return this.type.getId() + "[" + this.elementSize + "]";
        }
        return this.type.getId();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "[");
        sb.append("type=" + (Object)((Object)this.type));
        if (this.getName() != null) {
            sb.append(", name=" + this.getName());
        }
        if (this.data != null) {
            sb.append(", data=" + this.type.arrayToString(this.data));
        }
        sb.append("]");
        return sb.toString();
    }
}

