/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.client.opengex.oddl;

import com.github.atomicblom.weirdinggadget.client.opengex.oddl.BaseStructure;
import com.github.atomicblom.weirdinggadget.client.opengex.oddl.DataStructure;
import com.github.atomicblom.weirdinggadget.client.opengex.oddl.OddlLexer;
import com.github.atomicblom.weirdinggadget.client.opengex.oddl.PrimitiveStructure;
import com.github.atomicblom.weirdinggadget.client.opengex.oddl.PrimitiveType;
import com.github.atomicblom.weirdinggadget.client.opengex.oddl.Reference;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class OddlParser {
    private boolean debug = false;
    private static final Map<String, DataType> DATA_TYPES = new HashMap<String, DataType>();
    private OddlLexer in;
    private Map<String, BaseStructure> globals = new HashMap<String, BaseStructure>();
    private DataStructure root;

    public OddlParser(Reader in) throws IOException {
        this.in = new OddlLexer(in);
        this.root = new DataStructure("$", null, null);
    }

    public List<BaseStructure> parse() throws IOException {
        this.root.setChildren(this.parseStructContents(this.root, -1));
        this.resolveReferences(this.root);
        return this.root.getChildren();
    }

    protected static DataType getDataType(String s) {
        return DATA_TYPES.get(s);
    }

    protected BaseStructure resolveReference(DataStructure parent, Reference ref) throws IOException {
        if (ref.isGlobal()) {
            return this.root.findChild(ref.getReferenceTokens());
        }
        DataStructure searchRoot = parent;
        while (searchRoot.getParent() != null) {
            BaseStructure replace = searchRoot.findChild(ref.getReferenceTokens());
            if (replace != null) {
                return replace;
            }
            searchRoot = searchRoot.getParent();
        }
        return null;
    }

    protected void resolveReferences(DataStructure parent, PrimitiveStructure ps) throws IOException {
        if (ps.getPrimitiveType() != PrimitiveType.Ref) {
            return;
        }
        if (ps.getElementSize() != 0) {
            BaseStructure[][] refs;
            for (BaseStructure[] sub : refs = (BaseStructure[][])ps.getData()) {
                this.resolveReferences(parent, sub);
            }
        } else {
            this.resolveReferences(parent, (BaseStructure[])ps.getData());
        }
    }

    protected void resolveReferences(DataStructure parent, BaseStructure[] refs) throws IOException {
        for (int i = 0; i < refs.length; ++i) {
            if (refs[i] == null) continue;
            Reference ref = (Reference)refs[i];
            BaseStructure replace = this.resolveReference(parent, ref);
            if (replace == null) {
                this.in.error("Unresolved reference " + ref.getReference(), ref.getLocation());
            }
            refs[i] = replace;
        }
    }

    protected void resolveProperties(DataStructure child) throws IOException {
        for (Map.Entry<String, Object> e : child.getProperties().entrySet()) {
            Object value = e.getValue();
            if (!(value instanceof Reference)) continue;
            Reference ref = (Reference)value;
            BaseStructure replace = this.resolveReference(child, ref);
            if (replace == null) {
                this.in.error("Unresolved reference " + ref.getReference(), ref.getLocation());
            }
            e.setValue(replace);
        }
    }

    protected void resolveReferences(DataStructure parent) throws IOException {
        ListIterator<BaseStructure> it = parent.getChildren().listIterator();
        while (it.hasNext()) {
            BaseStructure child = it.next();
            if (child instanceof PrimitiveStructure) {
                this.resolveReferences(parent, (PrimitiveStructure)child);
                continue;
            }
            if (!(child instanceof DataStructure)) continue;
            this.resolveProperties((DataStructure)child);
            this.resolveReferences((DataStructure)child);
        }
    }

    protected Object parsePropertyValue(DataStructure parent) throws IOException {
        int c = this.in.nextNonWhitespace();
        if (c < 0) {
            this.in.error("Expected literal, found end of file");
        }
        if (c == 34) {
            this.in.pushBack(c);
            return this.in.parseString();
        }
        if (Character.isDigit(c) || c == 43 || c == 45) {
            this.in.pushBack(c);
            return this.in.parseUnknownNumber();
        }
        if (c == 36 || c == 37) {
            this.in.pushBack(c);
            String ref = this.in.parseReference();
            if (ref == null) {
                return null;
            }
            return new Reference(ref, this.in.lastPosition());
        }
        this.in.pushBack(c);
        String val = this.in.parseIdentifier("value");
        if ("true".equals(val)) {
            return Boolean.TRUE;
        }
        if ("false".equals(val)) {
            return Boolean.FALSE;
        }
        if ("null".equals(val)) {
            return null;
        }
        DataType type = OddlParser.getDataType(val);
        if (type == null) {
            this.in.error("Invalid property value:" + val, this.in.lastPosition());
            return null;
        }
        return type.getType();
    }

    protected Map<String, Object> parseProperties(DataStructure parent) throws IOException {
        int c;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.in.position(-1).clone();
        while ((c = this.in.nextNonWhitespace()) != 41) {
            if (c < 0) {
                this.in.error("Unexpected end of file in property values");
            }
            if (result.isEmpty()) {
                this.in.pushBack(c);
            } else if (c != 44) {
                this.in.error("Missing ',' in property values", this.in.position(-1));
            }
            String key = this.in.parseIdentifier("property");
            c = this.in.nextNonWhitespace();
            if (c != 61) {
                this.in.error("Expected '=', found:" + (char)c, this.in.position(-1));
            }
            Object value = this.parsePropertyValue(parent);
            result.put(key, value);
        }
        return result;
    }

    protected PrimitiveStructure parseArray(DataStructure parent, DataType dataType) throws IOException {
        if (this.debug) {
            System.out.println("\nparseArray(" + dataType + ")");
        }
        PrimitiveStructure result = new PrimitiveStructure(dataType.getType(), parent, (int[])this.in.lastPosition().clone());
        int c = this.in.nextNonWhitespace();
        int size = 0;
        if (c == 91) {
            size = (int)this.in.parseLong(-1L, true);
            c = this.in.nextNonWhitespace();
            if (c != 93) {
                this.in.error("Expected ']' but found '" + (char)c + "'", this.in.position(-1));
            } else {
                c = this.in.nextNonWhitespace();
            }
            result.setElementSize(size);
        }
        if (c == 37 || c == 36) {
            String name = this.in.parseIdentifier("name");
            result.setName((char)c + name);
            if (c == 36) {
                if (!this.root.addIndex(name, result)) {
                    this.in.error("Global name '" + name + "' is already used", this.in.lastPosition());
                }
            } else if (!parent.addIndex(name, result)) {
                this.in.error("Local name '" + name + "' is already used", this.in.lastPosition());
            }
            c = this.in.nextNonWhitespace();
        }
        if (c != 123) {
            this.in.error("Unexpected character '" + (char)c + "' at array start", this.in.position(-1));
        }
        Object array = dataType.parseArray(this.in, size);
        result.setData(array);
        if (this.debug) {
            System.out.print("\nArray[");
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    System.out.print(',');
                }
                System.out.print(Array.get(array, i));
            }
            System.out.println("]");
        }
        return result;
    }

    protected BaseStructure parseStruct(DataStructure parent) throws IOException {
        List<BaseStructure> children;
        String id = this.in.parseIdentifier("identifier");
        DataType type = OddlParser.getDataType(id);
        if (type != null) {
            return this.parseArray(parent, type);
        }
        if (this.debug) {
            System.out.println("\nidentifier:" + id + "  from:" + this.in.lastPosition()[0] + ":" + this.in.lastPosition()[1]);
        }
        DataStructure result = new DataStructure(id, parent, this.in.lastPosition());
        int c = this.in.nextNonWhitespace();
        if (c < 0) {
            this.in.error("End of file reached in structure header");
        }
        if (c == 36 || c == 37) {
            String name = this.in.parseIdentifier("name");
            result.setName((char)c + name);
            if (c == 36) {
                if (!this.root.addIndex(name, result)) {
                    this.in.error("Global name '" + name + "' is already used", this.in.lastPosition());
                }
            } else if (!parent.addIndex(name, result)) {
                this.in.error("Local name '" + name + "' is already used", this.in.lastPosition());
            }
            c = this.in.nextNonWhitespace();
        }
        if (c == 40) {
            Map<String, Object> props = this.parseProperties(result);
            result.setProperties(props);
            c = this.in.nextNonWhitespace();
        }
        if (c != 123) {
            this.in.error("No structure contents found", this.in.position());
        }
        if (!(children = this.parseStructContents(result, 125)).isEmpty()) {
            result.setChildren(children);
        }
        return result;
    }

    protected List<BaseStructure> parseStructContents(DataStructure parent, int end) throws IOException {
        int c;
        if (this.debug) {
            System.out.println("\nparseStructContents()");
        }
        ArrayList<BaseStructure> children = new ArrayList<BaseStructure>();
        while ((c = this.in.nextNonWhitespace()) != end) {
            if (c == -1) {
                this.in.error("Missing '" + (char)end + "' at EOF");
            }
            this.in.pushBack(c);
            BaseStructure o = this.parseStruct(parent);
            children.add(o);
        }
        return children;
    }

    public static void main(String ... args) throws Exception {
        for (String s : args) {
            OddlParser parser = new OddlParser(new BufferedReader(new FileReader(s), 16384));
            List<BaseStructure> o = parser.parse();
            System.out.println("\n" + s + " parsed as:");
            System.out.println(o);
        }
    }

    static {
        DATA_TYPES.put("bool", new BooleanType());
        DATA_TYPES.put("int8", new IntType(PrimitiveType.Int8, 255L, true));
        DATA_TYPES.put("int16", new IntType(PrimitiveType.Int16, 65535L, true));
        DATA_TYPES.put("int32", new IntType(PrimitiveType.Int32, -1L, true));
        DATA_TYPES.put("int64", new IntType(PrimitiveType.Int64));
        DATA_TYPES.put("unsigned_int8", new IntType(PrimitiveType.Uint8, 255L));
        DATA_TYPES.put("unsigned_int16", new IntType(PrimitiveType.Uint16, 65535L));
        DATA_TYPES.put("unsigned_int32", new IntType(PrimitiveType.Uint32, -1L));
        DATA_TYPES.put("unsigned_int64", new IntType(PrimitiveType.Uint64));
        DATA_TYPES.put("float", new FloatType());
        DATA_TYPES.put("double", new DoubleType());
        DATA_TYPES.put("string", new StringType());
        DATA_TYPES.put("ref", new RefType());
        DATA_TYPES.put("type", new TypeType());
    }

    protected static class IntType
    extends DataType {
        private long bitMask;
        private boolean signed;

        public IntType(PrimitiveType type) {
            this(type, -1L, true);
        }

        public IntType(PrimitiveType type, long bitMask) {
            this(type, bitMask, false);
        }

        public IntType(PrimitiveType type, long bitMask, boolean signed) {
            super(type);
            this.bitMask = bitMask;
            this.signed = signed;
        }

        protected Object toType(Number num) {
            Class jType = this.getType().getJavaType();
            if (jType == Long.TYPE || jType == Double.TYPE) {
                return num;
            }
            if (jType == Byte.TYPE) {
                return num.byteValue();
            }
            if (jType == Short.TYPE) {
                return num.shortValue();
            }
            if (jType == Integer.TYPE) {
                return num.intValue();
            }
            if (jType == Float.TYPE) {
                return Float.valueOf(num.floatValue());
            }
            throw new UnsupportedOperationException("Unhandled type:" + (Object)((Object)this.getType()));
        }

        @Override
        protected Object toArray(List list) {
            Object array = Array.newInstance(this.getType().getJavaType(), list.size());
            for (int i = 0; i < list.size(); ++i) {
                Object val = this.toType((Number)list.get(i));
                Array.set(array, i, val);
            }
            return array;
        }

        @Override
        public Object parseValue(OddlLexer in) throws IOException {
            return in.parseLong(this.bitMask, this.signed);
        }
    }

    protected static class DoubleType
    extends DataType {
        public DoubleType() {
            super(PrimitiveType.Double);
        }

        protected DoubleType(PrimitiveType type) {
            super(type);
        }

        protected Object fromBits(long value, int sign) {
            return Double.longBitsToDouble(value) * (double)sign;
        }

        @Override
        protected Object toArray(List list) {
            double[] result = new double[list.size()];
            for (int i = 0; i < result.length; ++i) {
                Number num = (Number)list.get(i);
                result[i] = num.doubleValue();
            }
            return result;
        }

        @Override
        public Object parseValue(OddlLexer in) throws IOException {
            return in.parseDouble();
        }
    }

    protected static class FloatType
    extends DoubleType {
        public FloatType() {
            super(PrimitiveType.Float);
        }

        @Override
        protected Object fromBits(long value, int sign) {
            return Float.valueOf(Float.intBitsToFloat((int)value) * (float)sign);
        }

        @Override
        protected Object toArray(List list) {
            float[] result = new float[list.size()];
            for (int i = 0; i < result.length; ++i) {
                Number num = (Number)list.get(i);
                result[i] = num.floatValue();
            }
            return result;
        }

        @Override
        public Object parseValue(OddlLexer in) throws IOException {
            return Float.valueOf(in.parseFloat());
        }
    }

    protected static class BooleanType
    extends DataType {
        public BooleanType() {
            super(PrimitiveType.Bool);
        }

        @Override
        protected Object toArray(List list) {
            boolean[] array = new boolean[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Boolean)list.get(i);
            }
            return array;
        }

        @Override
        public Object parseValue(OddlLexer in) throws IOException {
            String literal = in.parseIdentifier("bool");
            if ("true".equals(literal)) {
                return Boolean.TRUE;
            }
            if ("false".equals(literal)) {
                return Boolean.FALSE;
            }
            in.error("Invalid bool:" + literal, in.position());
            return null;
        }
    }

    protected static class RefType
    extends DataType {
        public RefType() {
            super(PrimitiveType.Ref);
        }

        @Override
        protected Object toArray(List list) throws IOException {
            BaseStructure[] array = new BaseStructure[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (BaseStructure)list.get(i);
            }
            return array;
        }

        @Override
        public Object parseValue(OddlLexer in) throws IOException {
            String ref = in.parseReference();
            if (ref == null) {
                return null;
            }
            return new Reference(ref, in.lastPosition());
        }
    }

    protected static class StringType
    extends DataType {
        public StringType() {
            super(PrimitiveType.String);
        }

        @Override
        protected Object toArray(List list) throws IOException {
            String[] array = new String[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (String)list.get(i);
            }
            return array;
        }

        @Override
        public Object parseValue(OddlLexer in) throws IOException {
            int c;
            String result = in.parseString();
            while ((c = in.nextNonWhitespace()) == 34) {
                in.pushBack(c);
                result = result + in.parseString();
            }
            in.pushBack(c);
            return result;
        }
    }

    protected static class TypeType
    extends DataType {
        public TypeType() {
            super(PrimitiveType.Type);
        }

        @Override
        protected Object toArray(List list) throws IOException {
            PrimitiveType[] array = new PrimitiveType[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (PrimitiveType)((Object)list.get(i));
            }
            return array;
        }

        @Override
        public Object parseValue(OddlLexer in) throws IOException {
            String val = in.parseIdentifier("type");
            DataType type = OddlParser.getDataType(val);
            if (type == null) {
                in.error("Invalid type literal:" + val, in.lastPosition());
                return null;
            }
            return type.getType();
        }
    }

    protected static abstract class DataType {
        private PrimitiveType type;

        protected DataType(PrimitiveType type) {
            this.type = type;
        }

        public PrimitiveType getType() {
            return this.type;
        }

        protected abstract Object parseValue(OddlLexer var1) throws IOException;

        protected abstract Object toArray(List var1) throws IOException;

        public Object parseArray(OddlLexer in, int size) throws IOException {
            int c;
            if (size == 0) {
                return this.parseArray(in);
            }
            ArrayList<Object> results = new ArrayList<Object>();
            while ((c = in.nextNonWhitespace()) != 125) {
                if (!results.isEmpty()) {
                    if (c == 44) {
                        c = in.nextNonWhitespace();
                    } else if (c < 0) {
                        in.error("Unexpected end of file in array");
                    } else {
                        in.error("Missing ',' in array values", in.position(-1));
                    }
                }
                if (c == 123) {
                    int[] pos = (int[])in.position(-1).clone();
                    Object o = this.parseArray(in);
                    int len = Array.getLength(o);
                    if (size != len) {
                        in.error("Expected " + size + " elements but found:" + len, pos);
                    }
                    results.add(o);
                    continue;
                }
                if (c < 0) {
                    in.error("Unexpected end of file in array");
                    continue;
                }
                in.error("Unexpected character '" + (char)c + "' in array", in.position(-1));
            }
            Object array = Array.newInstance(this.getType().getJavaType(), results.size(), size);
            for (int i = 0; i < results.size(); ++i) {
                Array.set(array, i, results.get(i));
            }
            return array;
        }

        public Object parseArray(OddlLexer in) throws IOException {
            int c;
            ArrayList<Object> results = new ArrayList<Object>();
            while ((c = in.nextNonWhitespace()) != 125) {
                if (!results.isEmpty()) {
                    if (c != 44) {
                        in.error("Missing ',' in array values", in.position(-1));
                    } else if (c < 0) {
                        in.error("Unexpected end of file in array values");
                    }
                } else {
                    in.pushBack(c);
                }
                Object o = this.parseValue(in);
                results.add(o);
            }
            return this.toArray(results);
        }
    }
}

