/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.client.opengex.oddl;

import com.github.atomicblom.weirdinggadget.client.opengex.oddl.BitSequence;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;

public class OddlLexer {
    private boolean debug = false;
    private PushbackReader reader;
    private int column = 1;
    private int line = 1;
    private int[] lastPos = new int[2];

    public OddlLexer(Reader in) {
        this.reader = new PushbackReader(in, 2);
    }

    public void error(String msg) throws IOException {
        throw new IOException(msg);
    }

    public void error(String msg, int[] pos) throws IOException {
        throw new IOException(msg + ", at:" + pos[0] + ":" + pos[1]);
    }

    protected boolean isWhitespace(int c) {
        return c <= 32;
    }

    protected boolean isIdStart(int c) {
        if (c == 95) {
            return true;
        }
        if (c >= 97 && c <= 122) {
            return true;
        }
        return c >= 65 && c <= 90;
    }

    protected boolean isId(int c) {
        if (this.isIdStart(c)) {
            return true;
        }
        return c >= 48 && c <= 57;
    }

    protected int parseComment() throws IOException {
        int c = this.read();
        if (c == 47) {
            while ((c = this.read()) >= 0 && c != 10) {
            }
        } else if (c == 42) {
            while ((c = this.read()) >= 0 && (c != 42 || (c = this.read()) != 47)) {
            }
        } else {
            this.error("Malformed comment beginning '/'" + (char)c, this.position(-1));
        }
        return c;
    }

    public int nextNonWhitespace() throws IOException {
        int c;
        while ((c = this.read()) >= 0) {
            if (c == 47) {
                if (this.parseComment() >= 0) continue;
                return -1;
            }
            if (this.isWhitespace(c)) continue;
            return c;
        }
        return -1;
    }

    public String parseIdentifier(String tokenType) throws IOException {
        int c = this.nextNonWhitespace();
        if (c < 0) {
            this.error("Expected " + tokenType + ", found end of file");
        }
        if (!this.isIdStart(c)) {
            this.error("Illegal " + tokenType + " start '" + (char)c + "'", this.position(-1));
        }
        this.position(-1);
        StringBuilder sb = new StringBuilder();
        sb.append((char)c);
        while ((c = this.read()) >= 0) {
            if (!this.isId(c)) {
                this.pushBack(c);
                break;
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    protected int parseHexDigit() throws IOException {
        int result;
        int c = this.read();
        if (c < 0) {
            this.error("Expected hexidecimal digit, found end of file");
        }
        if ((result = Character.digit(c, 16)) < 0) {
            this.error("Expected hexidecimal digit, found:" + (char)c, this.position(-1));
        }
        return result;
    }

    protected int parseHexSequence() throws IOException {
        int d1 = this.parseHexDigit();
        int d2 = this.parseHexDigit();
        return d1 * 16 + d2;
    }

    protected int parseUnicodeSequence(int length) throws IOException {
        int result = 0;
        for (int i = 0; i < length; ++i) {
            int d = this.parseHexDigit();
            result = result * 16 + d;
        }
        return result;
    }

    protected int parseEscapeSequence(boolean allowUnicode) throws IOException {
        int c = this.read();
        switch (c) {
            case 34: {
                return 34;
            }
            case 39: {
                return 39;
            }
            case 63: {
                return 63;
            }
            case 92: {
                return 92;
            }
            case 97: {
                return 7;
            }
            case 98: {
                return 8;
            }
            case 102: {
                return 12;
            }
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 118: {
                return 8;
            }
            case 120: {
                return this.parseHexSequence();
            }
            case -1: {
                this.error("Expected escape character, found end of file");
                break;
            }
            case 117: {
                if (allowUnicode) {
                    return this.parseUnicodeSequence(4);
                }
            }
            case 85: {
                if (allowUnicode) {
                    return this.parseUnicodeSequence(6);
                }
            }
            default: {
                this.error("Invalid escape character:" + c, this.lastPosition());
            }
        }
        return -1;
    }

    protected int parseCharacter(int c) throws IOException {
        if (c == 92) {
            c = this.parseEscapeSequence(false);
        }
        if (c < 0) {
            this.error("Expected character, found end of file");
        }
        if (!(c >= 32 && c <= 38 || c >= 40 && c <= 88 || c >= 93 && c <= 126)) {
            this.error("Character digit not in allowed range", this.position(-1));
        }
        return c;
    }

    protected long parseCharLiteral() throws IOException {
        int c;
        long result = 0L;
        while ((c = this.read()) != 39) {
            int d = this.parseCharacter(c);
            result = result * 256L + (long)c;
        }
        return result;
    }

    public String parseString() throws IOException {
        int c = this.nextNonWhitespace();
        if (c < 0) {
            this.error("Expected '\"', found end of file");
        }
        this.position(-1);
        if (c != 34) {
            this.error("Expected '\"', found:" + (char)c, this.lastPosition());
        }
        StringBuilder sb = new StringBuilder();
        while ((c = this.read()) >= 0 && c != 34) {
            if (c == 10) {
                this.error("Newline detected in string", this.lastPosition());
            }
            if (c == 92) {
                c = this.parseEscapeSequence(true);
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    protected long parseIntString(int radix, String radixName) throws IOException {
        int c;
        long value = 0L;
        boolean first = true;
        while ((c = this.read()) >= 0) {
            int d = Character.digit(c, radix);
            if (d < 0) {
                if (first) {
                    this.error("Unexpected character '" + (char)c + "' in " + radixName + " literal", this.position(-1));
                }
                this.pushBack(c);
                break;
            }
            value *= (long)radix;
            value += (long)d;
            first = false;
        }
        if (c == -1) {
            this.error("End of file reached in " + radixName + " literal");
        }
        return value;
    }

    protected double parseFloatString() throws IOException {
        int c;
        boolean first = true;
        double result = 0.0;
        while ((c = this.read()) >= 0 && c != 46) {
            int d = Character.digit(c, 10);
            if (d < 0) {
                if (!first) break;
                this.error("Unexpected character '" + (char)c + "' in floating point literal", this.position(-1));
                break;
            }
            result = result * 10.0 + (double)d;
            first = false;
        }
        if (c == 46) {
            double numerator = 0.0;
            double denominator = 1.0;
            while ((c = this.read()) >= 0) {
                int d = Character.digit(c, 10);
                if (d < 0) {
                    if (!first) break;
                    this.error("Unexpected character '" + (char)c + "' in floating point literal", this.position(-1));
                    break;
                }
                numerator *= 10.0;
                numerator += (double)d;
                denominator *= 10.0;
                first = false;
            }
            result += numerator / denominator;
        }
        if (c == -1) {
            this.error("Unexpected end of file in floating point literal");
        }
        if (c == 101 || c == 69) {
            int expSign = 1;
            c = this.read();
            if (c == 43 || c == 45) {
                expSign = c == 45 ? -1 : 1;
            } else {
                this.pushBack(c);
            }
            long exp = this.parseIntString(10, "exponent");
            if (exp == 0L) {
                this.error("Invalid exponent", this.lastPosition());
            }
            result *= Math.pow(10.0, exp * (long)expSign);
        } else {
            this.pushBack(c);
        }
        return result;
    }

    public double parseDouble() throws IOException {
        int sign = 1;
        int c = this.nextNonWhitespace();
        if (c == 43) {
            c = this.read();
        } else if (c == 45) {
            sign = -1;
            c = this.read();
        }
        if (c == 48) {
            int d = this.read();
            if (d == 120 || d == 88) {
                long val = (int)this.parseIntString(16, "hexidecimal");
                return Double.longBitsToDouble(val) * (double)sign;
            }
            if (d == 98 || d == 66) {
                return Double.longBitsToDouble(this.parseIntString(1, "binary")) * (double)sign;
            }
            this.pushBack(d);
        }
        this.pushBack(c);
        double result = this.parseFloatString() * (double)sign;
        return result;
    }

    public float parseFloat() throws IOException {
        int sign = 1;
        int c = this.nextNonWhitespace();
        if (c == 43) {
            c = this.read();
        } else if (c == 45) {
            sign = -1;
            c = this.read();
        }
        if (c == 48) {
            int d = this.read();
            if (d == 120 || d == 88) {
                int val = (int)this.parseIntString(16, "hexidecimal");
                return Float.intBitsToFloat(val) * (float)sign;
            }
            if (d == 98 || d == 66) {
                return Float.intBitsToFloat((int)this.parseIntString(1, "binary")) * (float)sign;
            }
            this.pushBack(d);
        }
        this.pushBack(c);
        float result = (float)(this.parseFloatString() * (double)sign);
        return result;
    }

    protected long signExtend(long value, long bitMask, boolean signed) throws IOException {
        long signBits;
        if (value != (value & bitMask)) {
            this.error("Number overflow", this.lastPosition());
        }
        if (signed && (value & (signBits = bitMask >> 1 ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            value = signBits | value;
        }
        return value;
    }

    protected void checkBits(long value, long bitMask, boolean signed) throws IOException {
        long signBits;
        if (!signed) {
            if (value != (value & bitMask)) {
                this.error("Number overflow", this.lastPosition());
            }
        } else if (value > 0L) {
            long signBits2 = bitMask >> 1 ^ 0xFFFFFFFFFFFFFFFFL;
            if ((value & signBits2) != 0L) {
                this.error("Number overflow", this.lastPosition());
            }
        } else if (value < 0L && (value & (signBits = bitMask >> 1 ^ 0xFFFFFFFFFFFFFFFFL)) != signBits) {
            this.error("Number overflow", this.lastPosition());
        }
    }

    public long parseLong(long bitMask, boolean signed) throws IOException {
        int sign = 1;
        int c = this.nextNonWhitespace();
        this.position(-1);
        if (c == 43) {
            c = this.read();
        } else if (c == 45) {
            sign = -1;
            c = this.read();
        }
        Long result = null;
        if (c == 48) {
            int d = this.read();
            if (d == 120 || d == 88) {
                result = this.parseIntString(16, "hexidecimal");
                result = this.signExtend(result, bitMask, signed) * (long)sign;
            } else if (d == 98 || d == 66) {
                result = this.parseIntString(2, "binary");
                result = this.signExtend(result, bitMask, signed) * (long)sign;
            } else {
                this.pushBack(d);
            }
        } else if (c == 39) {
            result = this.parseCharLiteral() * (long)sign;
        }
        if (result == null) {
            this.pushBack(c);
            result = this.parseIntString(10, "decimal") * (long)sign;
        }
        this.checkBits(result, bitMask, signed);
        return result;
    }

    public Number parseUnknownNumber() throws IOException {
        int c = this.nextNonWhitespace();
        if (c < 0) {
            this.error("Expected literal, found end of file");
        }
        this.position(-1);
        Number result = null;
        int sign = 1;
        if (c == 43 || c == 45) {
            sign = c == 45 ? -1 : 1;
            c = this.read();
        }
        if (c == 48) {
            int d = this.read();
            if (d == 120 || d == 88) {
                result = new BitSequence(this.parseIntString(16, "hexidecimal"), sign);
            } else if (d == 98 || d == 66) {
                result = new BitSequence(this.parseIntString(2, "binary"), sign);
            } else {
                this.pushBack(d);
            }
        } else if (c == 39) {
            result = this.parseCharLiteral() * (long)sign;
        }
        if (result == null) {
            this.pushBack(c);
            result = this.parseFloatString() * (double)sign;
        }
        return result;
    }

    public String parseReference() throws IOException {
        int c = this.nextNonWhitespace();
        if (c < 0) {
            this.error("Expected '$' or '%' but found end of file");
        }
        if (c == 110) {
            int[] pos = this.position(-1);
            String check = "ull";
            for (int i = 0; i < check.length(); ++i) {
                int c2 = this.read();
                if (c2 < 0) {
                    this.error("Unexpected end of file in reference");
                }
                if (check.charAt(i) == c2) continue;
                this.error("Expected '$' or '%' but found:" + (char)c, pos);
            }
            return null;
        }
        if (c != 36 && c != 37) {
            this.error("Expected '$' or '%' but found:" + (char)c, this.position(-1));
        }
        int[] pos = (int[])this.position(-1).clone();
        StringBuilder result = new StringBuilder();
        do {
            String id = this.parseIdentifier("reference");
            result.append((char)c);
            result.append(id);
            c = this.read();
            if (c >= 0) continue;
            this.error("Unexpected end of file in reference");
        } while (c == 37);
        this.pushBack(c);
        this.lastPos[0] = pos[0];
        this.lastPos[1] = pos[1];
        return result.toString();
    }

    public int[] position() {
        this.lastPos[0] = this.line;
        this.lastPos[1] = this.column;
        return this.lastPos;
    }

    public int[] position(int delta) {
        this.lastPos[0] = this.line;
        this.lastPos[1] = this.column + delta;
        return this.lastPos;
    }

    public int[] lastPosition() {
        return this.lastPos;
    }

    public void pushBack(int c) throws IOException {
        if (this.debug) {
            if (c == 10) {
                System.out.print("(<0x0a)");
            } else if (c == 13) {
                System.out.print("(<0x0d)");
            } else if (c == 9) {
                System.out.print("(<0x09)");
            } else {
                System.out.print("(<" + (char)c + ")");
            }
        }
        this.reader.unread(c);
        --this.column;
        if (c == 10) {
            --this.line;
        }
    }

    public int read() throws IOException {
        int c = this.reader.read();
        if (c <= 0) {
            return c;
        }
        if (c == 10) {
            ++this.line;
            this.column = 1;
        } else {
            ++this.column;
        }
        if (this.debug) {
            System.out.print((char)c);
        }
        return c;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.line + ":" + this.column + "]";
    }
}

