/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.orestages;

import java.util.List;
import java.util.ListIterator;
import net.darkhax.bookshelf.util.BlockUtils;
import net.darkhax.bookshelf.util.RenderUtils;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.event.StagesSyncedEvent;
import net.darkhax.orestages.OreStages;
import net.darkhax.orestages.api.OreTiersAPI;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OreTiersEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onHarvestCheck(PlayerEvent.HarvestCheck event) {
        Tuple<String, IBlockState> stageInfo = OreTiersAPI.getStageInfo(event.getTargetBlock());
        if (stageInfo != null && !GameStageHelper.hasStage((EntityPlayer)event.getEntityPlayer(), (String)((String)stageInfo.func_76341_a()))) {
            event.setCanHarvest(event.getEntityPlayer().func_184823_b((IBlockState)stageInfo.func_76340_b()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        Tuple<String, IBlockState> stageInfo = OreTiersAPI.getStageInfo(event.getWorld().func_180495_p(event.getPos()));
        if (!(stageInfo == null || event.getEntityPlayer() != null && GameStageHelper.hasStage((EntityPlayer)event.getEntityPlayer(), (String)((String)stageInfo.func_76341_a())))) {
            event.setUseBlock(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Tuple<String, IBlockState> stageInfo = OreTiersAPI.getStageInfo(event.getState());
        if (!(stageInfo == null || event.getPlayer() != null && GameStageHelper.hasStage((EntityPlayer)event.getPlayer(), (String)((String)stageInfo.func_76341_a())))) {
            event.setExpToDrop(0);
            if (!ForgeHooks.canHarvestBlock((Block)event.getState().func_177230_c(), (EntityPlayer)event.getPlayer(), (IBlockAccess)event.getWorld(), (BlockPos)event.getPos()) && BlockUtils.canHarvestSafely((IBlockState)((IBlockState)stageInfo.func_76340_b()), (EntityPlayer)event.getPlayer())) {
                BlockUtils.dropBlockSafely((World)event.getWorld(), (EntityPlayer)event.getPlayer(), (BlockPos)event.getPos(), (IBlockState)((IBlockState)stageInfo.func_76340_b()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        try {
            Tuple<String, IBlockState> stageInfo = OreTiersAPI.getStageInfo(event.getState());
            if (!(stageInfo == null || event.getEntityPlayer() != null && GameStageHelper.hasStage((EntityPlayer)event.getEntityPlayer(), (String)((String)stageInfo.func_76341_a())))) {
                event.setNewSpeed(BlockUtils.getBreakSpeedToMatch((IBlockState)event.getState(), (IBlockState)((IBlockState)stageInfo.func_76340_b()), (World)event.getEntityPlayer().field_70170_p, (EntityPlayer)event.getEntityPlayer(), (BlockPos)event.getPos()));
            }
        }
        catch (Exception e) {
            OreStages.LOG.trace("Error calculating mining speed!", new Object[]{e});
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockDrops(BlockEvent.HarvestDropsEvent event) {
        Tuple<String, IBlockState> stageInfo = OreTiersAPI.getStageInfo(event.getState());
        if (stageInfo != null) {
            if (event.getHarvester() == null && OreTiersAPI.NON_DEFAULTING.contains(event.getState())) {
                return;
            }
            if (event.getHarvester() == null || !GameStageHelper.hasStage((EntityPlayer)event.getHarvester(), (String)((String)stageInfo.func_76341_a()))) {
                event.getDrops().clear();
                NonNullList drops = NonNullList.func_191196_a();
                ((IBlockState)stageInfo.func_76340_b()).func_177230_c().getDrops(drops, (IBlockAccess)event.getWorld(), event.getPos(), (IBlockState)stageInfo.func_76340_b(), event.getFortuneLevel());
                event.getDrops().addAll(drops);
                event.setDropChance(ForgeEventFactory.fireBlockHarvesting((List)event.getDrops(), (World)event.getWorld(), (BlockPos)event.getPos(), (IBlockState)((IBlockState)stageInfo.func_76340_b()), (int)event.getFortuneLevel(), (float)event.getDropChance(), (boolean)event.isSilkTouching(), (EntityPlayer)event.getHarvester()));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onStageSync(StagesSyncedEvent event) {
        RenderUtils.markRenderersForReload((boolean)true);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onOverlayRendered(RenderGameOverlayEvent.Text event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74330_P && event.getRight() != null) {
            ListIterator<String> iterator = event.getRight().listIterator();
            block0: while (iterator.hasNext()) {
                String line = (String)iterator.next();
                if (line == null) continue;
                for (String string : OreTiersAPI.REPLACEMENT_IDS.keySet()) {
                    if (!line.equalsIgnoreCase(string)) continue;
                    iterator.set(OreTiersAPI.REPLACEMENT_IDS.get(line));
                    continue block0;
                }
            }
        }
    }
}

