/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.orestages;

import java.util.Map;
import net.darkhax.bookshelf.lib.LoggingHelper;
import net.darkhax.bookshelf.util.RenderUtils;
import net.darkhax.orestages.OreTiersEventHandler;
import net.darkhax.orestages.api.OreTiersAPI;
import net.darkhax.orestages.client.renderer.block.model.BakedModelTiered;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="orestages", name="Ore Stages", version="2.0.37", dependencies="required-after:bookshelf;required-after:gamestages@[2.0.89,);required-after:crafttweaker", certificateFingerprint="d476d1b22b218a10d845928d1665d45fce301b27", acceptedMinecraftVersions="[1.12.2]")
public class OreStages {
    public static final LoggingHelper LOG = new LoggingHelper("Ore Stages");

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent ev) {
        MinecraftForge.EVENT_BUS.register((Object)new OreTiersEventHandler());
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(listener -> OreStages.replaceModels());
    }

    @SideOnly(value=Side.CLIENT)
    private static void replaceModels() {
        LOG.info("Starting model replacement for {} blocks.", new Object[]{OreTiersAPI.STATE_MAP.size()});
        long time = System.currentTimeMillis();
        if (!OreTiersAPI.STATE_MAP.isEmpty()) {
            for (Map.Entry<IBlockState, Tuple<String, IBlockState>> entry : OreTiersAPI.STATE_MAP.entrySet()) {
                RenderUtils.setModelForState((IBlockState)entry.getKey(), (IBakedModel)new BakedModelTiered((String)entry.getValue().func_76341_a(), entry.getKey(), (IBlockState)entry.getValue().func_76340_b()));
            }
        } else {
            LOG.info("There are no block replacements. Has the mod been configured?", new Object[0]);
        }
        LOG.info("Model replacement finished. Took {}ms", new Object[]{System.currentTimeMillis() - time});
    }
}

