/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.blocks;

import com.blakebr0.cucumber.iface.IModelHelper;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.blocks.BlockBase;
import com.blakebr0.mysticalagriculture.lib.EssenceType;
import com.blakebr0.mysticalagriculture.lib.Tooltips;
import com.blakebr0.mysticalagriculture.tileentity.TileEntityTinkeringTable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTinkeringTable
extends BlockBase
implements ITileEntityProvider,
IModelHelper {
    public static final PropertyEnum<EssenceType.Type> VARIANT = PropertyEnum.func_177709_a((String)"variant", EssenceType.Type.class);

    public BlockTinkeringTable() {
        super("tinkering_table", Material.field_151573_f, SoundType.field_185852_e, 8.0f, 12.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EssenceType.Type.INFERIUM)));
        GameRegistry.registerTileEntity(TileEntityTinkeringTable.class, (String)"ma.tinkering_table");
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing heldItem, float side, float hitX, float hitY) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityTinkeringTable) {
            player.openGui((Object)MysticalAgriculture.INSTANCE, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityTinkeringTable();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityTinkeringTable tile = (TileEntityTinkeringTable)world.func_175625_s(pos);
        if (tile instanceof TileEntityTinkeringTable) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = tile.matrix.getStackInSlot(i);
                if (stack == null) continue;
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
            }
        }
        super.func_180663_b(world, pos, state);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return ((EssenceType.Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> stacks) {
        for (EssenceType.Type type : EssenceType.Type.values()) {
            stacks.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    public void initModels() {
        for (EssenceType.Type type : EssenceType.Type.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)type.getMetadata(), (ModelResourceLocation)new ModelResourceLocation("mysticalagriculture:" + this.func_149739_a().substring(8) + "_" + EssenceType.Type.byMetadata(type.getMetadata()).func_176610_l()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EssenceType.Type.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EssenceType.Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        String mat = "";
        switch (stack.func_77960_j()) {
            case 0: {
                mat = Tooltips.INFERIUM;
                break;
            }
            case 1: {
                mat = Tooltips.PRUDENTIUM;
                break;
            }
            case 2: {
                mat = Tooltips.INTERMEDIUM;
                break;
            }
            case 3: {
                mat = Tooltips.SUPERIUM;
                break;
            }
            case 4: {
                mat = Tooltips.SUPREMIUM;
            }
        }
        tooltip.add(Tooltips.MATERIAL + mat);
    }
}

