/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.immcraft.blocks.ModBlocks;
import mcjty.immcraft.blocks.inworldplacer.InWorldPlacerTE;
import mcjty.immcraft.blocks.inworldplacer.InWorldVerticalPlacerTE;
import mcjty.immcraft.varia.BlockTools;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketPlaceItem
implements IMessage {
    private BlockPos blockPos;
    private EnumFacing side;
    private Vec3d hitVec;

    public void fromBytes(ByteBuf buf) {
        this.blockPos = NetworkTools.readPos((ByteBuf)buf);
        this.side = EnumFacing.values()[buf.readShort()];
        this.hitVec = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.blockPos);
        buf.writeShort(this.side.ordinal());
        buf.writeDouble(this.hitVec.field_72450_a);
        buf.writeDouble(this.hitVec.field_72448_b);
        buf.writeDouble(this.hitVec.field_72449_c);
    }

    public PacketPlaceItem() {
    }

    public PacketPlaceItem(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketPlaceItem(RayTraceResult mouseOver) {
        this.blockPos = mouseOver.func_178782_a();
        this.side = mouseOver.field_178784_b;
        this.hitVec = new Vec3d(mouseOver.field_72307_f.field_72450_a - (double)this.blockPos.func_177958_n(), mouseOver.field_72307_f.field_72448_b - (double)this.blockPos.func_177956_o(), mouseOver.field_72307_f.field_72449_c - (double)this.blockPos.func_177952_p());
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            EntityPlayerMP player = ctx.getSender();
            ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
            if (heldItem.func_190926_b()) {
                return;
            }
            World world = player.func_130014_f_();
            Block block = world.func_180495_p(this.blockPos).func_177230_c();
            if (world.func_175623_d(this.blockPos.func_177984_a()) && BlockTools.isTopValidAndSolid(world, this.blockPos) && this.side == EnumFacing.UP) {
                BlockTools.placeBlock(world, this.blockPos.func_177984_a(), ModBlocks.inWorldPlacerBlock, (EntityPlayer)player);
                BlockTools.getInventoryTE(world, this.blockPos.func_177984_a()).ifPresent(p -> InWorldPlacerTE.addItems(p, (EntityPlayer)player, heldItem));
            } else if (world.func_175623_d(this.blockPos.func_177972_a(this.side)) && BlockTools.isSideValidAndSolid(world, this.blockPos, this.side, block)) {
                BlockTools.placeBlock(world, this.blockPos.func_177972_a(this.side), ModBlocks.inWorldVerticalPlacerBlock, (EntityPlayer)player);
                BlockTools.getInventoryTE(world, this.blockPos.func_177972_a(this.side)).ifPresent(p -> InWorldVerticalPlacerTE.addItems(p, (EntityPlayer)player, heldItem));
            }
        });
        ctx.setPacketHandled(true);
    }
}

