/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.immcraft.blocks.generic.GenericBlockWithTE;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketHitBlock
implements IMessage {
    private BlockPos blockPos;
    private EnumFacing side;
    private Vec3d hitVec;

    public void fromBytes(ByteBuf buf) {
        this.blockPos = NetworkTools.readPos((ByteBuf)buf);
        this.side = EnumFacing.values()[buf.readShort()];
        this.hitVec = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.blockPos);
        buf.writeShort(this.side.ordinal());
        buf.writeDouble(this.hitVec.field_72450_a);
        buf.writeDouble(this.hitVec.field_72448_b);
        buf.writeDouble(this.hitVec.field_72449_c);
    }

    public PacketHitBlock() {
    }

    public PacketHitBlock(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketHitBlock(RayTraceResult mouseOver) {
        this.blockPos = mouseOver.func_178782_a();
        this.side = mouseOver.field_178784_b;
        this.hitVec = new Vec3d(mouseOver.field_72307_f.field_72450_a - (double)this.blockPos.func_177958_n(), mouseOver.field_72307_f.field_72448_b - (double)this.blockPos.func_177956_o(), mouseOver.field_72307_f.field_72449_c - (double)this.blockPos.func_177952_p());
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            EntityPlayerMP player = ctx.getSender();
            Block block = player.func_130014_f_().func_180495_p(this.blockPos).func_177230_c();
            if (block instanceof GenericBlockWithTE) {
                GenericBlockWithTE genericBlockWithTE = (GenericBlockWithTE)block;
                genericBlockWithTE.onClick(player.func_130014_f_(), this.blockPos, (EntityPlayer)player);
            }
        });
        ctx.setPacketHandled(true);
    }
}

