/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.network;

import java.util.HashMap;
import java.util.Map;
import mcjty.immcraft.multiblock.MultiblockInfoPacketClient;
import mcjty.immcraft.multiblock.MultiblockInfoPacketServer;
import mcjty.immcraft.network.InfoPacketClient;
import mcjty.immcraft.network.InfoPacketServer;
import mcjty.immcraft.network.IngredientsInfoPacketClient;
import mcjty.immcraft.network.IngredientsInfoPacketServer;
import mcjty.immcraft.network.PacketGetInfoFromServer;
import mcjty.immcraft.network.PacketHitBlock;
import mcjty.immcraft.network.PacketPageFlip;
import mcjty.immcraft.network.PacketPlaceItem;
import mcjty.immcraft.network.PacketReturnInfoToClient;
import mcjty.immcraft.network.PacketSendKey;
import mcjty.lib.network.PacketHandler;
import mcjty.lib.thirteen.ChannelBuilder;
import mcjty.lib.thirteen.SimpleChannel;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public class ImmCraftPacketHandler {
    private static int packetId = 0;
    public static SimpleNetworkWrapper INSTANCE = null;
    private static Map<Integer, Class<? extends InfoPacketClient>> clientInfoPackets = new HashMap<Integer, Class<? extends InfoPacketClient>>();
    private static Map<Integer, Class<? extends InfoPacketServer>> serverInfoPackets = new HashMap<Integer, Class<? extends InfoPacketServer>>();
    private static Map<Class<? extends InfoPacketClient>, Integer> clientInfoPacketsToId = new HashMap<Class<? extends InfoPacketClient>, Integer>();
    private static Map<Class<? extends InfoPacketServer>, Integer> serverInfoPacketsToId = new HashMap<Class<? extends InfoPacketServer>, Integer>();

    public static int infoId() {
        return packetId++;
    }

    private static void register(Integer id, Class<? extends InfoPacketServer> serverClass, Class<? extends InfoPacketClient> clientClass) {
        serverInfoPackets.put(id, serverClass);
        clientInfoPackets.put(id, clientClass);
        serverInfoPacketsToId.put(serverClass, id);
        clientInfoPacketsToId.put(clientClass, id);
    }

    public static Class<? extends InfoPacketServer> getServerInfoPacket(int id) {
        return serverInfoPackets.get(id);
    }

    public static Integer getServerInfoPacketId(Class<? extends InfoPacketServer> clazz) {
        return serverInfoPacketsToId.get(clazz);
    }

    public static Class<? extends InfoPacketClient> getClientInfoPacket(int id) {
        return clientInfoPackets.get(id);
    }

    public static Integer getClientInfoPacketId(Class<? extends InfoPacketClient> clazz) {
        return clientInfoPacketsToId.get(clazz);
    }

    public static void registerMessages(String name) {
        SimpleChannel net = ChannelBuilder.named((ResourceLocation)new ResourceLocation("immcraft", name)).networkProtocolVersion(() -> "1.0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
        INSTANCE = net.getNetwork();
        net.registerMessageServer(ImmCraftPacketHandler.id(), PacketSendKey.class, PacketSendKey::toBytes, PacketSendKey::new, PacketSendKey::handle);
        net.registerMessageServer(ImmCraftPacketHandler.id(), PacketPlaceItem.class, PacketPlaceItem::toBytes, PacketPlaceItem::new, PacketPlaceItem::handle);
        net.registerMessageServer(ImmCraftPacketHandler.id(), PacketGetInfoFromServer.class, PacketGetInfoFromServer::toBytes, PacketGetInfoFromServer::new, PacketGetInfoFromServer::handle);
        net.registerMessageServer(ImmCraftPacketHandler.id(), PacketHitBlock.class, PacketHitBlock::toBytes, PacketHitBlock::new, PacketHitBlock::handle);
        net.registerMessageClient(ImmCraftPacketHandler.id(), PacketReturnInfoToClient.class, PacketReturnInfoToClient::toBytes, PacketReturnInfoToClient::new, PacketReturnInfoToClient::handle);
        net.registerMessageClient(ImmCraftPacketHandler.id(), PacketPageFlip.class, PacketPageFlip::toBytes, PacketPageFlip::new, PacketPageFlip::handle);
        ImmCraftPacketHandler.register(ImmCraftPacketHandler.infoId(), IngredientsInfoPacketServer.class, IngredientsInfoPacketClient.class);
        ImmCraftPacketHandler.register(ImmCraftPacketHandler.infoId(), MultiblockInfoPacketServer.class, MultiblockInfoPacketClient.class);
    }

    private static int id() {
        return PacketHandler.nextPacketID();
    }
}

