/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.cables;

import mcjty.immcraft.api.cable.ICable;
import mcjty.immcraft.api.cable.ICableConnector;
import mcjty.immcraft.api.cable.ICableSection;
import mcjty.immcraft.api.cable.ICableSubType;
import mcjty.immcraft.api.cable.ICableType;
import mcjty.immcraft.api.helpers.NBTHelper;
import mcjty.immcraft.cables.CableRegistry;
import mcjty.immcraft.cables.CableSectionRender;
import mcjty.lib.varia.BlockPosTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class CableSection
implements ICableSection {
    private final ICableType type;
    private final ICableSubType subType;
    private int id;
    private ConnectionInfo[] info = new ConnectionInfo[]{new ConnectionInfo(), new ConnectionInfo()};
    private final Vec3d vector;

    public CableSection(NBTTagCompound tagCompound) {
        this.type = CableRegistry.getTypeByID(tagCompound.func_74779_i("type"));
        this.subType = this.type.getSubTypeByID(tagCompound.func_74779_i("subtype"));
        this.id = tagCompound.func_74762_e("id");
        this.vector = new Vec3d((double)tagCompound.func_74760_g("vx"), (double)tagCompound.func_74760_g("vy"), (double)tagCompound.func_74760_g("vz"));
        this.info[0].readFromNBT(tagCompound, "0");
        this.info[1].readFromNBT(tagCompound, "1");
    }

    public CableSection(ICableType type, ICableSubType subType, int id, Vec3d vector) {
        this.id = id;
        this.type = type;
        this.subType = subType;
        this.vector = vector;
    }

    public CableSectionRender getRenderer(BlockPos pos) {
        Vec3d v1 = this.getVector(0);
        Vec3d v2 = this.getVector(1);
        return new CableSectionRender(this.subType, this.vector.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), v1 == null ? null : v1.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), v2 == null ? null : v2.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public ICableType getType() {
        return this.type;
    }

    @Override
    public ICableSubType getSubType() {
        return this.subType;
    }

    public void setConnection(int directionId, BlockPos connection, Vec3d vector, int connectorId) {
        this.info[directionId].setConnection(connection);
        this.info[directionId].setVector(vector);
        this.info[directionId].setConnectorId(connectorId);
    }

    public BlockPos getConnection(int directionId) {
        return this.info[directionId].getConnection();
    }

    public Vec3d getVector() {
        return this.vector;
    }

    public Vec3d getVector(int directionId) {
        return this.info[directionId].getVector();
    }

    public ICable getCable(World world) {
        return this.type.getCableHandler().getCable(world, this.subType, this.id);
    }

    public int getConnectorID(int idx) {
        return this.info[idx].getConnectorId();
    }

    public void releaseConnector(World world, int directionId) {
        this.info[directionId].releaseConnector(world);
    }

    @Override
    public ICableConnector getConnector(World worldObj, int directionId) {
        return this.info[directionId].getConnector(worldObj);
    }

    public NBTHelper writeToNBT(NBTHelper helper) {
        helper.set("type", this.type.getTypeID()).set("subtype", this.subType.getTypeID()).set("id", this.id).set("v", this.vector);
        this.info[0].writeToNBT(helper, "0");
        this.info[1].writeToNBT(helper, "1");
        return helper;
    }

    private static class ConnectionInfo {
        private Vec3d vector;
        private BlockPos connection;
        private int connectorId;

        private ConnectionInfo() {
        }

        public Vec3d getVector() {
            return this.vector;
        }

        public void setVector(Vec3d vector) {
            this.vector = vector;
        }

        public BlockPos getConnection() {
            return this.connection;
        }

        public void setConnection(BlockPos connection) {
            this.connection = connection;
        }

        public int getConnectorId() {
            return this.connectorId;
        }

        public void setConnectorId(int connectorId) {
            this.connectorId = connectorId;
        }

        public void releaseConnector(World world) {
            ICableConnector c = this.getConnector(world);
            if (c != null && this.connectorId != -1) {
                c.disconnect(this.connectorId);
            }
        }

        public ICableConnector getConnector(World worldObj) {
            if (this.connection == null) {
                return null;
            }
            TileEntity te = worldObj.func_175625_s(this.connection);
            if (te instanceof ICableConnector) {
                return (ICableConnector)te;
            }
            return null;
        }

        public void readFromNBT(NBTTagCompound tagCompound, String suffix) {
            String vk = "v" + suffix;
            this.vector = tagCompound.func_74764_b(vk + "x") ? new Vec3d((double)tagCompound.func_74760_g(vk + "x"), (double)tagCompound.func_74760_g(vk + "y"), (double)tagCompound.func_74760_g(vk + "z")) : null;
            this.connection = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)("c" + suffix));
            this.connectorId = tagCompound.func_74762_e("i" + suffix);
        }

        public NBTHelper writeToNBT(NBTHelper helper, String suffix) {
            return helper.set("i" + suffix, this.connectorId).set("c" + suffix, this.connection).set("v" + suffix, this.vector);
        }
    }
}

