/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.cables;

import mcjty.immcraft.api.helpers.IntersectionTools;
import mcjty.immcraft.blocks.bundle.BundleTE;
import mcjty.immcraft.cables.CableSection;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.Vec3d;

public class CableRenderer {
    public static CableSection findSelectedCable(Vec3d player, Vec3d hitVec, BundleTE bundleTE) {
        CableSection closestSection = null;
        float mindist = 1000000.0f;
        for (CableSection section : bundleTE.getCableSections()) {
            Vec3d vector = section.getVector();
            Vec3d vector1 = section.getVector(0);
            if (vector1 == null) {
                vector1 = new Vec3d(vector.field_72450_a + (double)0.2f, vector.field_72448_b + (double)0.2f, vector.field_72449_c + (double)0.2f);
            }
            Vec3d vector2 = section.getVector(1);
            float dist = IntersectionTools.calculateRayToLineDistance(player, hitVec.func_178788_d(player), vector, vector1);
            if (dist < mindist) {
                mindist = dist;
                closestSection = section;
            }
            if (vector2 == null || !((dist = IntersectionTools.calculateRayToLineDistance(player, hitVec.func_178788_d(player), vector, vector2)) < mindist)) continue;
            mindist = dist;
            closestSection = section;
        }
        return closestSection;
    }

    public static void renderHilightedCable(Vec3d player, CableSection section) {
    }

    public static void renderCable(Vec3d player, CableSection section) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        Vec3d vector = section.getVector();
        Vec3d vector1 = section.getVector(0);
        if (vector1 == null) {
            vector1 = new Vec3d(vector.field_72450_a + (double)0.2f, vector.field_72448_b + (double)0.2f, vector.field_72449_c + (double)0.2f);
        }
        Vec3d vector2 = section.getVector(1);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        CableRenderer.drawBeamExtended(player, vector, vector1);
        if (vector2 != null) {
            CableRenderer.drawBeamExtended(player, vector, vector2);
        }
        tessellator.func_78381_a();
    }

    private static void drawBeamExtended(Vec3d player, Vec3d v1, Vec3d v2) {
        Vec3d diff = v2.func_178788_d(v1).func_72432_b().func_186678_a((double)0.02f);
    }
}

