/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.cables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mcjty.immcraft.api.cable.ICable;
import mcjty.immcraft.api.cable.ICableSection;
import mcjty.immcraft.api.cable.ICableSubType;
import mcjty.immcraft.api.cable.ICableType;
import mcjty.immcraft.api.multiblock.IMultiBlock;
import mcjty.immcraft.api.multiblock.IMultiBlockClientInfo;
import mcjty.immcraft.blocks.bundle.BundleTE;
import mcjty.immcraft.cables.CableClientInfo;
import mcjty.immcraft.cables.CableSection;
import mcjty.lib.varia.BlockPosTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Cable
implements IMultiBlock,
ICable {
    private final ICableType type;
    private final ICableSubType subType;
    private List<BlockPos> path = new ArrayList<BlockPos>();
    private int clientBlockSize = -1;

    public Cable(ICableType type, ICableSubType subType) {
        this.type = type;
        this.subType = subType;
    }

    public ICableType getType() {
        return this.type;
    }

    public ICableSubType getSubType() {
        return this.subType;
    }

    @Override
    public IMultiBlockClientInfo getClientInfo() {
        return new CableClientInfo(this.getBlockCount());
    }

    @Override
    public int getBlockCount() {
        return this.clientBlockSize == -1 ? this.path.size() : this.clientBlockSize;
    }

    public void setClientBlockCount(int c) {
        this.clientBlockSize = c;
    }

    @Override
    public Collection<BlockPos> getBlocks() {
        return this.path;
    }

    @Override
    public void addBlock(BlockPos coordinate) {
        if (this.path.isEmpty()) {
            this.path.add(coordinate);
        } else if (BlockPosTools.isAdjacent((BlockPos)this.path.get(0), (BlockPos)coordinate)) {
            ArrayList<BlockPos> newpath = new ArrayList<BlockPos>();
            newpath.add(coordinate);
            newpath.addAll(this.path);
            this.path = newpath;
        } else if (BlockPosTools.isAdjacent((BlockPos)this.path.get(this.path.size() - 1), (BlockPos)coordinate)) {
            this.path.add(coordinate);
        } else {
            throw new RuntimeException("Not possible! Trying to add an invalid point to a path");
        }
    }

    @Override
    public List<BlockPos> getPath() {
        return this.path;
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        int idx = 0;
        for (BlockPos c : this.path) {
            BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)("path" + idx), (BlockPos)c);
            ++idx;
        }
        tagCompound.func_74768_a("pathSize", idx);
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        int pathSize = tagCompound.func_74762_e("pathSize");
        this.path = new ArrayList<BlockPos>(pathSize);
        for (int i = 0; i < pathSize; ++i) {
            this.path.add(BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)("path" + i)));
        }
    }

    @Override
    public boolean canConnect(IMultiBlock other, BlockPos pos) {
        if (other == null) {
            if (this.path.isEmpty()) {
                return true;
            }
            if (BlockPosTools.isAdjacent((BlockPos)this.path.get(0), (BlockPos)pos)) {
                return true;
            }
            return BlockPosTools.isAdjacent((BlockPos)this.path.get(this.path.size() - 1), (BlockPos)pos);
        }
        if (!(other instanceof Cable)) {
            return false;
        }
        if (this.path.isEmpty()) {
            return true;
        }
        Cable otherCable = (Cable)other;
        if (otherCable.path.isEmpty()) {
            return true;
        }
        if (!Collections.disjoint(this.path, otherCable.path)) {
            return false;
        }
        if (BlockPosTools.isAdjacent((BlockPos)this.path.get(0), (BlockPos)otherCable.path.get(0))) {
            return true;
        }
        if (BlockPosTools.isAdjacent((BlockPos)this.path.get(0), (BlockPos)otherCable.path.get(otherCable.path.size() - 1))) {
            return true;
        }
        if (BlockPosTools.isAdjacent((BlockPos)this.path.get(this.path.size() - 1), (BlockPos)otherCable.path.get(0))) {
            return true;
        }
        return BlockPosTools.isAdjacent((BlockPos)this.path.get(this.path.size() - 1), (BlockPos)otherCable.path.get(otherCable.path.size() - 1));
    }

    @Override
    public void merge(World world, int networkId, IMultiBlock other, int otherId) {
        ArrayList<BlockPos> newpath;
        Cable otherCable = (Cable)other;
        if (BlockPosTools.isAdjacent((BlockPos)this.path.get(0), (BlockPos)otherCable.path.get(0))) {
            newpath = new ArrayList<BlockPos>(otherCable.path);
            Collections.reverse(newpath);
            newpath.addAll(this.path);
            this.path = newpath;
        } else if (BlockPosTools.isAdjacent((BlockPos)this.path.get(0), (BlockPos)otherCable.path.get(otherCable.path.size() - 1))) {
            newpath = new ArrayList<BlockPos>(otherCable.path);
            newpath.addAll(this.path);
            this.path = newpath;
        } else if (BlockPosTools.isAdjacent((BlockPos)this.path.get(this.path.size() - 1), (BlockPos)otherCable.path.get(0))) {
            this.path.addAll(otherCable.path);
        } else if (BlockPosTools.isAdjacent((BlockPos)this.path.get(this.path.size() - 1), (BlockPos)otherCable.path.get(otherCable.path.size() - 1))) {
            ArrayList<BlockPos> otherPath = new ArrayList<BlockPos>(otherCable.path);
            Collections.reverse(otherPath);
            this.path.addAll(otherPath);
        }
        for (BlockPos c : this.path) {
            BundleTE bundle;
            ICableSection section;
            TileEntity te = world.func_175625_s(c);
            if (!(te instanceof BundleTE) || (section = (bundle = (BundleTE)te).findSection(this.type, this.subType, otherId)) == null) continue;
            ((CableSection)section).setId(networkId);
        }
    }

    @Override
    public Collection<? extends IMultiBlock> remove(World world, BlockPos c) {
        ArrayList<Cable> multiBlocks = new ArrayList<Cable>();
        int idx = this.path.indexOf(c);
        if (idx != -1) {
            if (idx > 0) {
                Cable cable1 = new Cable(this.type, this.subType);
                cable1.path = new ArrayList<BlockPos>(this.path.subList(0, idx));
                multiBlocks.add(cable1);
            }
            if (idx < this.path.size() - 1) {
                Cable cable2 = new Cable(this.type, this.subType);
                cable2.path = new ArrayList<BlockPos>(this.path.subList(idx + 1, this.path.size()));
                multiBlocks.add(cable2);
            }
        } else {
            throw new RuntimeException("Impossible!");
        }
        return multiBlocks;
    }
}

