/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.books;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mcjty.immcraft.api.book.IBook;
import mcjty.immcraft.blocks.book.BookStandTE;
import mcjty.immcraft.books.BookPage;
import mcjty.immcraft.books.BookParser;
import mcjty.immcraft.books.BookRenderHelper;
import mcjty.immcraft.books.RenderSection;
import mcjty.immcraft.books.TextElementFormat;
import mcjty.immcraft.books.renderers.RenderElementText;
import mcjty.immcraft.setup.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class GuiManual
extends GuiScreen {
    private static final int WIDTH = 200;
    private static final int HEIGHT = 220;
    private int guiLeft;
    private int guiTop;
    private ResourceLocation json;
    private List<BookPage> pages;
    private int pageNumber = 0;
    private String result = null;
    private static final ResourceLocation background = new ResourceLocation("immcraft", "textures/gui/manual_paper.png");
    private static final ResourceLocation backgroundFront = new ResourceLocation("immcraft", "textures/gui/manual_front.png");

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - 200) / 2;
        this.guiTop = (this.field_146295_m - 220) / 2;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack book = player.func_184614_ca();
        if (!book.func_190926_b() && book.func_77973_b() instanceof IBook) {
            this.json = ((IBook)book.func_77973_b()).getJson();
            BookParser parser = new BookParser();
            this.pages = parser.parse(this.json, 768, 900);
            this.pageNumber = 0;
            this.result = null;
        } else {
            this.json = null;
            this.pages = new ArrayList<BookPage>();
            this.pages.add(new BookPage());
            RenderSection section = new RenderSection("Error");
            TextElementFormat fmt = new TextElementFormat("red,bold");
            section.addElement(new RenderElementText("Error!", 10, 10, (int)ClientProxy.font.getWidth("Error!"), (int)ClientProxy.font.getHeight(), fmt));
            this.pages.get(0).addSection(section);
            this.pageNumber = 0;
            this.result = null;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        if (this.result != null) {
            if ("<".equals(this.result)) {
                this.pageDec();
            } else if (">".equals(this.result)) {
                this.pageInc();
            } else if ("^".equals(this.result)) {
                this.pageFront();
            } else {
                int number = BookStandTE.findPageForSection(this.pages, this.result);
                if (number != -1 && number != this.pageNumber) {
                    this.pageNumber = number;
                    this.playPageTurn();
                }
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (keyCode == 57 || keyCode == 205) {
            this.pageInc();
        } else if (keyCode == 203 || keyCode == 14) {
            this.pageDec();
        } else if (keyCode == 199) {
            this.pageFront();
        }
    }

    private void pageFront() {
        if (this.pageNumber != 0) {
            this.pageNumber = 0;
            this.playPageTurn();
        }
    }

    private void pageInc() {
        if (this.pageNumber < this.pages.size() - 1) {
            ++this.pageNumber;
            this.playPageTurn();
        }
    }

    private void pageDec() {
        if (this.pageNumber > 0) {
            --this.pageNumber;
            this.playPageTurn();
        }
    }

    private void playPageTurn() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        BookStandTE.playPageTurn((World)Minecraft.func_71410_x().field_71441_e, player.func_180425_c());
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.pageNumber == 0) {
            this.field_146297_k.func_110434_K().func_110577_a(backgroundFront);
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(background);
        }
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 200, 220);
        float ix = (float)(mouseX - this.guiLeft) / 200.0f;
        float iy = (float)(mouseY - this.guiTop) / 220.0f;
        this.result = ix < 0.15f ? "<" : (ix > 0.9f ? ">" : (iy < 0.15f ? "^" : null));
        String rc = BookRenderHelper.renderPageForGUI(this.pages, this.pageNumber, 1.0f, ix, iy, this.guiLeft, this.guiTop);
        if (rc != null) {
            this.result = rc;
        }
    }
}

