/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.blocks.generic;

import java.util.Optional;
import mcjty.immcraft.api.helpers.InventoryHelper;
import mcjty.immcraft.api.helpers.NBTHelper;
import mcjty.immcraft.blocks.generic.GenericImmcraftTE;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class GenericInventoryTE
extends GenericImmcraftTE
implements ISidedInventory {
    protected InventoryHelper inventoryHelper;
    private int[] accessible;
    private IItemHandler invHandler = new InvWrapper((IInventory)this);

    public GenericInventoryTE(int count) {
        this.inventoryHelper = new InventoryHelper((TileEntity)this, count);
    }

    public static Optional<GenericInventoryTE> castGenericInventoryTE(TileEntity te) {
        return te instanceof GenericInventoryTE ? Optional.of((GenericInventoryTE)te) : Optional.empty();
    }

    public int[] func_180463_a(EnumFacing side) {
        if (this.accessible == null) {
            this.accessible = new int[this.inventoryHelper.getCount()];
            for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
                this.accessible[i] = i;
            }
        }
        return this.accessible;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isUsable(EntityPlayer player) {
        return !this.func_145837_r() && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174888_l() {
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.inventoryHelper.getStackInSlot(index);
        this.inventoryHelper.setStackInSlot(index, ItemStack.field_190927_a);
        return stack;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public String func_70005_c_() {
        return "inv";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.readBufferFromNBT(tagCompound);
    }

    protected void setStack(int index, ItemStack stack) {
        this.inventoryHelper.setStackInSlot(index, stack);
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.setStack(i, new ItemStack(nbtTagCompound));
        }
    }

    @Override
    public void writeToNBT(NBTHelper helper) {
        super.writeToNBT(helper);
        this.writeBufferToNBT(helper);
    }

    private void writeBufferToNBT(NBTHelper helper) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (!stack.func_190926_b()) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        helper.set("Items", bufferTagList);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getItemHandlerForSide(facing));
        }
        return (T)super.getCapability(capability, facing);
    }

    protected IItemHandler getItemHandlerForSide(EnumFacing facing) {
        return this.invHandler;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.isUsable(player);
    }

    public boolean func_191420_l() {
        return false;
    }
}

