/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.blocks.book;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mcjty.immcraft.blocks.book.BookStandTE;
import mcjty.immcraft.blocks.book.BookStandTESR;
import mcjty.immcraft.blocks.book.EnumStandState;
import mcjty.immcraft.blocks.book.PropertyStandState;
import mcjty.immcraft.blocks.generic.GenericBlockWithTE;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BookStandBlock
extends GenericBlockWithTE<BookStandTE> {
    public static final PropertyStandState STATE = PropertyStandState.create("state", Arrays.stream(EnumStandState.values()).collect(Collectors.toList()));
    public static final AxisAlignedBB EMPTY = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public BookStandBlock() {
        super(Material.field_151575_d, "bookstand", BookStandTE.class, false);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
    }

    public void initModel() {
        super.initModel();
        BookStandTESR.register();
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof BookStandTE && ((BookStandTE)te).hasBook()) {
            probeInfo.text(TextFormatting.BLUE + "Sneak-right click to remove book");
        }
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getWorld().func_175625_s(accessor.getPosition());
        if (te instanceof BookStandTE && ((BookStandTE)te).hasBook()) {
            currenttip.add(TextFormatting.BLUE + "Sneak-right click to remove book");
        }
        return currenttip;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return EMPTY;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te;
        TileEntity tileEntity = te = worldIn instanceof ChunkCache ? ((ChunkCache)worldIn).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : worldIn.func_175625_s(pos);
        if (te instanceof BookStandTE) {
            BookStandTE bookStandTE = (BookStandTE)te;
            EnumStandState bookState = bookStandTE.getState();
            return state.func_177226_a((IProperty)STATE, (Comparable)((Object)bookState));
        }
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING_HORIZ, STATE});
    }
}

