/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.api.rendering;

import javax.annotation.Nonnull;
import mcjty.immcraft.api.IImmersiveCraft;
import mcjty.immcraft.api.generic.GenericBlock;
import mcjty.immcraft.api.generic.GenericTE;
import mcjty.immcraft.api.handles.IInterfaceHandle;
import mcjty.immcraft.api.rendering.BlockRenderHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class HandleTESR<T extends GenericTE>
extends TileEntitySpecialRenderer<T> {
    protected final GenericBlock block;
    protected Vec3d textOffset = new Vec3d(0.0, 0.0, 0.0);

    public HandleTESR(GenericBlock block) {
        this.block = block;
    }

    @Nonnull
    protected abstract IImmersiveCraft getApi();

    public void render(T tileEntity, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IBlockState state = tileEntity.func_145831_w().func_180495_p(tileEntity.func_174877_v());
        if (!(state.func_177230_c() instanceof GenericBlock)) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GlStateManager.func_179101_C();
        BlockRenderHelper.rotateFacing(tileEntity, this.block.getRotationType());
        this.renderExtra(tileEntity);
        this.renderHandles(tileEntity);
        GlStateManager.func_179121_F();
    }

    protected void renderHandles(T tileEntity) {
        double distanceSq = Minecraft.func_71410_x().field_71439_g.func_174818_b(tileEntity.func_174877_v());
        if (distanceSq > this.getApi().getMaxHandleRenderDistanceSquared()) {
            return;
        }
        this.func_147499_a(TextureMap.field_110575_b);
        IInterfaceHandle selectedHandle = BlockRenderHelper.getFacingInterfaceHandle(tileEntity, this.block);
        BlockRenderHelper.renderInterfaceHandles(this.getApi(), tileEntity, selectedHandle, this.textOffset);
    }

    protected void renderExtra(T tileEntity) {
    }
}

