/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.api.helpers;

import mcjty.lib.varia.BlockPosTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class NBTHelper {
    private final NBTTagCompound tag;

    private NBTHelper(NBTTagCompound tag) {
        this.tag = tag;
    }

    public static NBTHelper create(NBTTagCompound tag) {
        return new NBTHelper(tag);
    }

    public static NBTHelper create() {
        return new NBTHelper(new NBTTagCompound());
    }

    public NBTHelper set(String name, int value) {
        this.tag.func_74768_a(name, value);
        return this;
    }

    public NBTHelper set(String name, float value) {
        this.tag.func_74776_a(name, value);
        return this;
    }

    public NBTHelper set(String name, double value) {
        this.tag.func_74780_a(name, value);
        return this;
    }

    public NBTHelper set(String name, boolean value) {
        this.tag.func_74757_a(name, value);
        return this;
    }

    public NBTHelper set(String name, String value) {
        this.tag.func_74778_a(name, value);
        return this;
    }

    public NBTHelper set(String name, NBTTagList tc) {
        this.tag.func_74782_a(name, (NBTBase)tc);
        return this;
    }

    public NBTHelper set(String name, NBTTagCompound tc) {
        this.tag.func_74782_a(name, (NBTBase)tc);
        return this;
    }

    public NBTHelper set(String name, BlockPos c) {
        BlockPosTools.writeToNBT((NBTTagCompound)this.tag, (String)name, (BlockPos)c);
        return this;
    }

    public NBTHelper set(String name, Vec3d c) {
        if (c != null) {
            this.tag.func_74776_a(name + "x", (float)c.field_72450_a);
            this.tag.func_74776_a(name + "y", (float)c.field_72448_b);
            this.tag.func_74776_a(name + "z", (float)c.field_72449_c);
        }
        return this;
    }

    public NBTTagCompound get() {
        return this.tag;
    }
}

