/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.armoreablemobs.entity;

import crafttweaker.annotations.ZenRegister;
import java.util.HashMap;
import net.minecraft.command.CommandBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.armoreablemobs.ArmorEntity")
public class ArmorEntity {
    private String id;
    private HashMap<NBTContainer, NBTCheckMode> nbtChecks;

    public ArmorEntity(String id) {
        this.id = id;
        this.nbtChecks = new HashMap();
    }

    @ZenMethod
    public ArmorEntity withNBTCheck(String key, int object, String mode) {
        this.nbtChecks.put(new NBTContainer(key, object), NBTCheckMode.valueOf(mode));
        return this;
    }

    @ZenMethod
    public ArmorEntity withNBTCheck(String key, double object, String mode) {
        this.nbtChecks.put(new NBTContainer(key, Float.valueOf((float)object)), NBTCheckMode.valueOf(mode));
        return this;
    }

    @ZenMethod
    public ArmorEntity withNBTCheck(String key, String object, String mode) {
        this.nbtChecks.put(new NBTContainer(key, object), NBTCheckMode.valueOf(mode));
        return this;
    }

    public boolean checkEntity(Entity entity) {
        if (EntityList.func_191301_a((Entity)entity) == null || !EntityList.func_191301_a((Entity)entity).toString().equals(this.id)) {
            return false;
        }
        for (NBTContainer container : this.nbtChecks.keySet()) {
            if (this.nbtChecks.get(container).checkNbt(CommandBase.func_184887_a((Entity)entity), container)) continue;
            return false;
        }
        return true;
    }

    private class NBTContainer {
        public String key;
        public Object value;

        public NBTContainer(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }

    private static enum NBTCheckMode {
        LESS{

            @Override
            public boolean checkNbt(NBTTagCompound tag, NBTContainer container) {
                return tag.func_150297_b(container.key, 5) && container.value instanceof Float && tag.func_74760_g(container.key) < ((Float)container.value).floatValue() || tag.func_150297_b(container.key, 3) && container.value instanceof Integer && tag.func_74762_e(container.key) < (Integer)container.value;
            }
        }
        ,
        EQUAL{

            @Override
            public boolean checkNbt(NBTTagCompound tag, NBTContainer container) {
                return tag.func_74764_b(container.key) && tag.func_74781_a(container.key).equals(container.value);
            }
        }
        ,
        GREATER{

            @Override
            public boolean checkNbt(NBTTagCompound tag, NBTContainer container) {
                return tag.func_150297_b(container.key, 5) && container.value instanceof Float && tag.func_74760_g(container.key) > ((Float)container.value).floatValue() || tag.func_150297_b(container.key, 3) && container.value instanceof Integer && tag.func_74762_e(container.key) > (Integer)container.value;
            }
        }
        ,
        CONTAINS{

            @Override
            public boolean checkNbt(NBTTagCompound tag, NBTContainer container) {
                return tag.func_150297_b(container.key, 8) && container.value instanceof String && tag.func_74779_i(container.key).contains((String)container.value);
            }
        }
        ,
        TAG_EXISTS{

            @Override
            public boolean checkNbt(NBTTagCompound tag, NBTContainer container) {
                return tag.func_74764_b(container.key);
            }
        }
        ,
        TAG_MISSING{

            @Override
            public boolean checkNbt(NBTTagCompound tag, NBTContainer container) {
                return !tag.func_74764_b(container.key);
            }
        };


        public abstract boolean checkNbt(NBTTagCompound var1, NBTContainer var2);
    }
}

